/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.core.transport;

public final class ProxyHost {
    private String host;
    private int port;
    private String username;
    private String password;

    public ProxyHost(String host, int port) {
        this(host, port, null, null);
    }

    private ProxyHost(String host, int port, String username, String password) {
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
    }

    public static ProxyHost of(String host, int port) {
        return new ProxyHost(host, port);
    }

    public static ProxyHost of(String host, int port, String username, String password) {
        return new ProxyHost(host, port, username, password);
    }

    public String getHost() {
        return this.host;
    }

    public String getRawHost() {
        if (this.host != null && this.host.startsWith("http")) {
            return this.host.substring(this.host.indexOf("://") + 3);
        }
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getHostWithPort() {
        return String.format("%s:%d", this.host, this.port);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
        result = 31 * result + this.port;
        result = 31 * result + (this.username == null ? 0 : this.username.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProxyHost other = (ProxyHost)obj;
        if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
            return false;
        }
        if (this.password == null ? other.password != null : !this.password.equals(other.password)) {
            return false;
        }
        if (this.port != other.port) {
            return false;
        }
        return !(this.username == null ? other.username != null : !this.username.equals(other.username));
    }
}

