/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.model.compute;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huawei.openstack4j.model.ModelEntity;
import com.huawei.openstack4j.model.common.Link;
import com.huawei.openstack4j.model.compute.Addresses;
import com.huawei.openstack4j.model.compute.Fault;
import com.huawei.openstack4j.model.compute.Flavor;
import com.huawei.openstack4j.model.compute.Image;
import com.huawei.openstack4j.model.compute.SecurityGroup;
import java.util.Date;
import java.util.List;
import java.util.Map;

public interface Server
extends ModelEntity {
    public String getId();

    public String getName();

    public Addresses getAddresses();

    public List<? extends Link> getLinks();

    public String getImageId();

    public Image getImage();

    public String getFlavorId();

    public Flavor getFlavor();

    public String getAccessIPv4();

    public String getAccessIPv6();

    public String getConfigDrive();

    public Status getStatus();

    public int getProgress();

    public Fault getFault();

    public String getTenantId();

    public String getUserId();

    public String getKeyName();

    public String getHostId();

    public Date getUpdated();

    public Date getCreated();

    public Map<String, String> getMetadata();

    public String getTaskState();

    public String getPowerState();

    public String getVmState();

    public String getHost();

    public String getInstanceName();

    public String getHypervisorHostname();

    public DiskConfig getDiskConfig();

    public String getAvailabilityZone();

    public Date getLaunchedAt();

    public Date getTerminatedAt();

    public List<String> getOsExtendedVolumesAttached();

    public String getUuid();

    public String getAdminPass();

    public List<? extends SecurityGroup> getSecurityGroups();

    public Integer getMaxCount();

    public Integer getMinCount();

    public String getDescription();

    public HostStatus getHostStatus();

    public String getHostname();

    public String getReservationId();

    public Integer getLaunchIndex();

    public String getKernelId();

    public String getRamdiskId();

    public String getRootDeviceName();

    public String getUserData();

    public Boolean getLocked();

    public List<String> getTags();

    public Map<String, String> getSchedulerHints();

    public static enum HostStatus {
        UP,
        UNKNOWN,
        DOWN,
        MAINTENANCE,
        NOHOSTSTATUS;


        @JsonCreator
        public static HostStatus forValue(String value) {
            if (value != null && !"".equals(value)) {
                for (HostStatus s : HostStatus.values()) {
                    if (!s.name().equalsIgnoreCase(value)) continue;
                    return s;
                }
            }
            return NOHOSTSTATUS;
        }
    }

    public static enum DiskConfig {
        MANUAL,
        AUTO;


        @JsonCreator
        public static DiskConfig forValue(String value) {
            if (value != null && value.equalsIgnoreCase("auto")) {
                return AUTO;
            }
            return MANUAL;
        }
    }

    public static enum Status {
        ACTIVE,
        BUILD,
        REBUILD,
        SUSPENDED,
        PAUSED,
        RESIZE,
        VERIFY_RESIZE,
        REVERT_RESIZE,
        PASSWORD,
        REBOOT,
        HARD_REBOOT,
        DELETED,
        UNKNOWN,
        ERROR,
        STOPPED,
        SHUTOFF,
        MIGRATING,
        SHELVED,
        SHELVED_OFFLOADED,
        UNRECOGNIZED;


        @JsonCreator
        public static Status forValue(String value) {
            if (value != null) {
                for (Status s : Status.values()) {
                    if (!s.name().equalsIgnoreCase(value)) continue;
                    return s;
                }
            }
            return UNRECOGNIZED;
        }

        @JsonValue
        public String value() {
            return this.name().toLowerCase();
        }
    }
}

