/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.model.compute.actions;

import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Map;

public class BaseActionOptions {
    private static final String OPT_FMT = "\"%s\": \"%s\"";
    private Map<OptionEnum, Object> options = Maps.newHashMap();

    protected BaseActionOptions() {
    }

    protected void add(OptionEnum option, Object value) {
        this.options.put(option, value);
    }

    protected <T> T get(OptionEnum option) {
        return (T)this.options.get(option);
    }

    public String toJsonString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{\n");
        Iterator<OptionEnum> it = this.options.keySet().iterator();
        while (it.hasNext()) {
            OptionEnum opt = it.next();
            sb.append(String.format(OPT_FMT, opt.getParam(), this.options.get(opt)));
            if (!it.hasNext()) continue;
            sb.append(",\n");
        }
        sb.append("\n}");
        return sb.toString();
    }

    public static interface OptionEnum {
        public String getParam();
    }
}

