/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.model.compute.actions;

import com.huawei.openstack4j.model.compute.actions.BaseActionOptions;

public class LiveMigrateOptions
extends BaseActionOptions {
    private LiveMigrateOptions() {
        this.add(Option.HOST, null);
        this.add(Option.BLOCK_MIGRATION, false);
        this.add(Option.DISK_OVER_COMMIT, false);
    }

    public static LiveMigrateOptions create() {
        return new LiveMigrateOptions();
    }

    public LiveMigrateOptions host(String host) {
        this.add(Option.HOST, host);
        return this;
    }

    public LiveMigrateOptions blockMigration(boolean blocked) {
        this.add(Option.BLOCK_MIGRATION, blocked);
        return this;
    }

    public LiveMigrateOptions diskOverCommit(boolean enabled) {
        this.add(Option.DISK_OVER_COMMIT, enabled);
        return this;
    }

    public String getHost() {
        return (String)this.get(Option.HOST);
    }

    public boolean getBlockMigration() {
        return (Boolean)this.get(Option.BLOCK_MIGRATION);
    }

    public boolean getDiskOverCommit() {
        return (Boolean)this.get(Option.DISK_OVER_COMMIT);
    }

    private static enum Option implements BaseActionOptions.OptionEnum
    {
        HOST("host"),
        BLOCK_MIGRATION("block_migration"),
        DISK_OVER_COMMIT("disk_over_commit");

        private final String param;

        private Option(String param) {
            this.param = param;
        }

        @Override
        public String getParam() {
            return this.param;
        }
    }
}

