/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.model.image;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huawei.openstack4j.common.Buildable;
import com.huawei.openstack4j.model.common.BasicResource;
import com.huawei.openstack4j.model.image.ContainerFormat;
import com.huawei.openstack4j.model.image.DiskFormat;
import com.huawei.openstack4j.model.image.StoreType;
import com.huawei.openstack4j.model.image.builder.ImageBuilder;
import java.util.Date;
import java.util.Map;
import javax.annotation.Nullable;

public interface Image
extends BasicResource,
Buildable<ImageBuilder> {
    public ContainerFormat getContainerFormat();

    public DiskFormat getDiskFormat();

    public Long getSize();

    public String getChecksum();

    public long getMinDisk();

    public long getMinRam();

    public String getLocation();

    @Nullable
    public String getOwner();

    public Date getUpdatedAt();

    public Date getCreatedAt();

    @Nullable
    public Date getDeletedAt();

    public Status getStatus();

    public boolean isPublic();

    public boolean isDeleted();

    public boolean isProtected();

    public Map<String, String> getProperties();

    public StoreType getStoreType();

    public boolean isSnapshot();

    public String getCopyFrom();

    public static enum Status {
        UNRECOGNIZED,
        ACTIVE,
        SAVING,
        QUEUED,
        KILLED,
        PENDING_DELETE,
        DELETED;


        @JsonCreator
        public static Status value(String v) {
            if (v == null) {
                return UNRECOGNIZED;
            }
            try {
                return Status.valueOf(v.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }

        @JsonValue
        public String value() {
            return this.name().toLowerCase();
        }
    }
}

