/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.model.image.v2;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huawei.openstack4j.common.Buildable;
import com.huawei.openstack4j.model.common.BasicResource;
import com.huawei.openstack4j.model.image.v2.ContainerFormat;
import com.huawei.openstack4j.model.image.v2.DiskFormat;
import com.huawei.openstack4j.model.image.v2.builder.ImageBuilder;
import java.util.Date;
import java.util.List;

public interface Image
extends BasicResource,
Buildable<ImageBuilder> {
    public ImageStatus getStatus();

    @Override
    public String getName();

    public List<String> getTags();

    public ContainerFormat getContainerFormat();

    public Date getCreatedAt();

    public DiskFormat getDiskFormat();

    public Date getUpdatedAt();

    public Long getMinDisk();

    public Boolean getIsProtected();

    @Override
    public String getId();

    public Long getMinRam();

    public String getChecksum();

    public String getOwner();

    public ImageVisibility getVisibility();

    public Long getSize();

    public List<String> getLocations();

    public String getDirectUrl();

    public String getSelf();

    public String getFile();

    public String getSchema();

    public String getRamdiskId();

    public String getOsDistro();

    public String getOsVersion();

    public String getKernelId();

    public String getInstanceUuid();

    public String getArchitecture();

    public Long getVirtualSize();

    public String getAdditionalPropertyValue(String var1);

    public String getBackupId();

    public Boolean getDeleted();

    public String getDescription();

    public String getVirtualEnvType();

    public String getImageSourceType();

    public String getDeletedAt();

    public String getOriginalImageName();

    public String getProductCode();

    public String getImageSize();

    public String getDataOrigin();

    public String getEnterpriseProjectId();

    public String getIsRegistered();

    public String getImageType();

    public String getOsBit();

    public String getPlatForm();

    public String getOsType();

    public String getSupportKvm();

    public String getSupportXen();

    public String getSupportDiskIntensive();

    public String getSupportHighPerformance();

    public String getSupportXenGpuType();

    public String getSequenceNum();

    public static enum ImageVisibility {
        PUBLIC,
        PRIVATE,
        UNKNOWN;


        @JsonCreator
        public static ImageVisibility forValue(String value) {
            if (value != null) {
                for (ImageVisibility s : ImageVisibility.values()) {
                    if (!s.name().equalsIgnoreCase(value)) continue;
                    return s;
                }
            }
            return UNKNOWN;
        }

        @JsonValue
        public String value() {
            return this.name().toLowerCase();
        }
    }

    public static enum ImageStatus {
        UNRECOGNIZED,
        QUEUED,
        SAVING,
        ACTIVE,
        DEACTIVATED,
        KILLED,
        DELETED,
        PENDING_DELETE;


        @JsonCreator
        public static ImageStatus value(String v) {
            if (v == null) {
                return UNRECOGNIZED;
            }
            try {
                return ImageStatus.valueOf(v.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }

        @JsonValue
        public String value() {
            return this.name().toLowerCase();
        }
    }
}

