/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.model.loadbalance;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Strings;
import com.huawei.openstack4j.model.ModelEntity;
import java.util.Date;

public interface Listener
extends ModelEntity {
    public String getId();

    public String getName();

    public String getDescription();

    public String getLoadBalancerId();

    public Protocol getProtocol();

    public Integer getPort();

    public BackendProtocol getBackendProtocol();

    public Integer getBackendPort();

    public LbAlgorithm getLbAlgorithm();

    public Boolean getSessionSticky();

    public StickySessionType getStickySessionType();

    public Integer getCookieTimeout();

    public String getCertificateId();

    public Status getStatus();

    public Boolean getAdminStateUp();

    public String getHealthCheckId();

    public Boolean getTcpDraining();

    public Integer getTcpDrainingTimeout();

    public Date getCreateTime();

    public Date getUpdateTime();

    public String getClientCaTlsContainerRef();

    public Integer getMemberNumber();

    public Integer getTcpTimeout();

    public SSLProtocols getSslProtocols();

    public SSLCiphers getSslCiphers();

    public Integer getUdpTimeout();

    public static enum StickySessionType {
        INSERT("insert");

        private String val;

        private StickySessionType(String val) {
            this.val = val;
        }

        @JsonValue
        public String getVal() {
            return this.val;
        }

        @JsonCreator
        public StickySessionType forValue(String value) {
            if (!Strings.isNullOrEmpty((String)value)) {
                for (StickySessionType type : StickySessionType.values()) {
                    if (!type.getVal().equalsIgnoreCase(value)) continue;
                    return type;
                }
            }
            return null;
        }
    }

    public static enum SSLCiphers {
        DEFAULT("Default"),
        EXTENDED("Extended"),
        STRICT("Strict");

        private String val;

        private SSLCiphers(String val) {
            this.val = val;
        }

        @JsonValue
        public String getVal() {
            return this.val;
        }

        @JsonCreator
        public SSLCiphers forValue(String value) {
            if (!Strings.isNullOrEmpty((String)value)) {
                for (SSLCiphers cipher : SSLCiphers.values()) {
                    if (!cipher.getVal().equalsIgnoreCase(value)) continue;
                    return cipher;
                }
            }
            return null;
        }
    }

    public static enum SSLProtocols {
        TLS_1_2("TLSv1.2"),
        TLS_1_1("TLSv1.1"),
        TLS_1("TLSv1");

        private String val;

        private SSLProtocols(String val) {
            this.val = val;
        }

        @JsonValue
        public String getVal() {
            return this.val;
        }

        @JsonCreator
        public SSLProtocols forValue(String value) {
            if (!Strings.isNullOrEmpty((String)value)) {
                for (SSLProtocols p : SSLProtocols.values()) {
                    if (!p.getVal().equalsIgnoreCase(value)) continue;
                    return p;
                }
            }
            return null;
        }
    }

    public static enum LbAlgorithm {
        ROUND_ROBIN("roundrobin"),
        LEAST_CONN("leastconn"),
        SOURCE("source");

        private String val;

        private LbAlgorithm(String val) {
            this.val = val;
        }

        @JsonValue
        public String getVal() {
            return this.val;
        }

        @JsonCreator
        public LbAlgorithm forValue(String value) {
            if (!Strings.isNullOrEmpty((String)value)) {
                for (LbAlgorithm la : LbAlgorithm.values()) {
                    if (!la.getVal().equalsIgnoreCase(value)) continue;
                    return la;
                }
            }
            return null;
        }
    }

    public static enum BackendProtocol {
        HTTP,
        TCP,
        UDP;


        @JsonCreator
        public BackendProtocol forValue(String value) {
            if (!Strings.isNullOrEmpty((String)value)) {
                for (BackendProtocol p : BackendProtocol.values()) {
                    if (!p.name().equalsIgnoreCase(value)) continue;
                    return p;
                }
            }
            return null;
        }
    }

    public static enum Protocol {
        HTTP,
        TCP,
        HTTPS,
        UDP;


        @JsonCreator
        public Protocol forValue(String value) {
            if (!Strings.isNullOrEmpty((String)value)) {
                for (Protocol p : Protocol.values()) {
                    if (!p.name().equalsIgnoreCase(value)) continue;
                    return p;
                }
            }
            return null;
        }
    }

    public static enum Status {
        ACTIVE,
        PENDING_CREATE,
        ERROR;


        @JsonCreator
        public Status forValue(String value) {
            if (!Strings.isNullOrEmpty((String)value)) {
                for (Status status : Status.values()) {
                    if (!status.name().equalsIgnoreCase(value)) continue;
                    return status;
                }
            }
            return null;
        }
    }
}

