/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.model.loadbalance;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Strings;
import com.huawei.openstack4j.model.ModelEntity;
import com.huawei.openstack4j.model.loadbalance.LoadBalancer;

public interface LoadBalancerCreate
extends ModelEntity {
    public String getName();

    public String getDescription();

    public String getVpcId();

    public Integer getBandwidth();

    public LoadBalancer.Type getType();

    public Integer getAdminStateUp();

    public String getVipSubnetId();

    public String getAzId();

    public ChargeMode getChargeMode();

    public EipType getEipType();

    public String getSecurityGroupId();

    public String getVipAddress();

    public String getTenantId();

    public static enum EipType {
        TELCOM_5("5_telcom"),
        UNION_5("5_union"),
        BGP_5("5_bgp");

        private String val;

        private EipType(String val) {
            this.val = val;
        }

        @JsonValue
        public String getVal() {
            return this.val;
        }

        @JsonCreator
        public EipType forValue(String value) {
            if (!Strings.isNullOrEmpty((String)value)) {
                for (EipType type : EipType.values()) {
                    if (!type.getVal().equalsIgnoreCase(value)) continue;
                    return type;
                }
            }
            return null;
        }
    }

    public static enum ChargeMode {
        BANDWIDTH("bandwidth"),
        TRAFFIC("traffic");

        private String val;

        private ChargeMode(String val) {
            this.val = val;
        }

        @JsonValue
        public String getVal() {
            return this.val;
        }

        @JsonCreator
        public ChargeMode forValue(String value) {
            if (!Strings.isNullOrEmpty((String)value)) {
                for (ChargeMode mode : ChargeMode.values()) {
                    if (!mode.getVal().equalsIgnoreCase(value)) continue;
                    return mode;
                }
            }
            return null;
        }
    }
}

