/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.model.manila;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huawei.openstack4j.model.ModelEntity;
import com.huawei.openstack4j.model.common.Link;
import java.util.List;
import java.util.Map;

public interface Share
extends ModelEntity {
    public String getId();

    public Status getStatus();

    public List<? extends Link> getLinks();

    public String getProjectId();

    public Protocol getShareProto();

    public Integer getSize();

    public String getName();

    public String getDescription();

    public String getDisplayName();

    public String getDisplayDescription();

    public String getShareType();

    public String getShareTypeName();

    public String getVolumeType();

    public String getSnapshotId();

    public Boolean isPublic();

    public Map<String, String> getMetadata();

    public String getShareNetworkId();

    public String getAvailabilityZone();

    public String getExportLocation();

    public List<String> getExportLocations();

    public String getHost();

    public TaskState getTaskState();

    public String getShareServerId();

    public String getConsistencyGroupId();

    public Boolean getSnapshotSupport();

    public String getSourceCgsnapshotMemberId();

    public String getCreatedAt();

    public static enum TaskState {
        NULL,
        MIGRATION_STARTING,
        MIGRATION_ERROR,
        MIGRATION_SUCCESS,
        MIGRATION_COMPLETING,
        MIGRATING;


        @JsonCreator
        public static TaskState value(String v) {
            return TaskState.valueOf(v.toUpperCase());
        }

        @JsonValue
        public String value() {
            return this.name().toLowerCase();
        }
    }

    public static enum Protocol {
        NFS,
        CIFS,
        GlusterFS,
        HDFS;

    }

    public static enum Status {
        CREATING,
        DELETING,
        ERROR,
        ERROR_DELETING,
        AVAILABLE,
        MANAGE_STARTING,
        UNMANAGE_STARTING,
        UNMANAGE_ERROR,
        UNMANAGED,
        EXTENDING,
        EXTENDING_ERROR,
        SHRINKING,
        SHRINKING_ERROR,
        SHRINKING_POSSIBLE_DATA_LOSS_ERROR;


        @JsonCreator
        public static Status value(String v) {
            return Status.valueOf(v.toUpperCase());
        }

        @JsonValue
        public String value() {
            return this.name().toLowerCase();
        }
    }
}

