/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.model.map.reduce;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.huawei.openstack4j.common.Buildable;
import com.huawei.openstack4j.model.ModelEntity;
import com.huawei.openstack4j.model.map.reduce.NodeGroup;
import com.huawei.openstack4j.model.map.reduce.ServiceConfig;
import com.huawei.openstack4j.model.map.reduce.ServiceInfo;
import com.huawei.openstack4j.model.map.reduce.builder.ClusterBuilder;
import java.util.Date;
import java.util.List;
import java.util.Map;

public interface Cluster
extends ModelEntity,
Buildable<ClusterBuilder> {
    public Status getStatus();

    public Map<String, ? extends ServiceInfo> getInfos();

    public String getClusterTemplateId();

    public Boolean isTransient();

    public String getDescription();

    public Map<String, ? extends ServiceConfig> getClusterConfigs();

    public Date getCreatedAt();

    public String getDefaultImageId();

    public String getUserKeypairId();

    public Date getUpdatedAt();

    public String getPluginName();

    public String getManagementNetworkId();

    public List<String> getAntiAffinity();

    public String getTenantId();

    public List<? extends NodeGroup> getNodeGroups();

    public String getManagementPublicKey();

    public String getStatusDescription();

    public String getHadoopVersion();

    public String getId();

    public String getTrustId();

    public String getName();

    public static enum Status {
        UNRECOGNIZED,
        VALIDATING,
        INFRAUPDATING,
        SPAWNING,
        WAITING,
        PREPARING,
        CONFIGURING,
        STARTING,
        ACTIVE,
        SCALING,
        ADDING,
        DECOMMISSIONING,
        DELETING,
        ERROR;


        @JsonCreator
        public static Status forValue(String value) {
            if (value != null) {
                for (Status s : Status.values()) {
                    if (!value.toUpperCase().startsWith(s.name())) continue;
                    return s;
                }
            }
            return UNRECOGNIZED;
        }
    }
}

