/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.model.scaling;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Strings;
import com.huawei.openstack4j.model.ModelEntity;
import com.huawei.openstack4j.model.scaling.Bandwidth;
import java.beans.ConstructorProperties;

public class Eip
implements ModelEntity {
    private static final long serialVersionUID = -1069053200085079737L;
    @JsonProperty(value="ip_type")
    private String ipType;
    @JsonProperty
    private Bandwidth bandwidth;

    public static EipBuilder builder() {
        return new EipBuilder();
    }

    public String getIpType() {
        return this.ipType;
    }

    public Bandwidth getBandwidth() {
        return this.bandwidth;
    }

    public String toString() {
        return "Eip(ipType=" + this.getIpType() + ", bandwidth=" + this.getBandwidth() + ")";
    }

    public Eip() {
    }

    @ConstructorProperties(value={"ipType", "bandwidth"})
    public Eip(String ipType, Bandwidth bandwidth) {
        this.ipType = ipType;
        this.bandwidth = bandwidth;
    }

    public static class EipBuilder {
        private String ipType;
        private Bandwidth bandwidth;

        EipBuilder() {
        }

        public EipBuilder ipType(String ipType) {
            this.ipType = ipType;
            return this;
        }

        public EipBuilder bandwidth(Bandwidth bandwidth) {
            this.bandwidth = bandwidth;
            return this;
        }

        public Eip build() {
            return new Eip(this.ipType, this.bandwidth);
        }

        public String toString() {
            return "Eip.EipBuilder(ipType=" + this.ipType + ", bandwidth=" + this.bandwidth + ")";
        }
    }

    @Deprecated
    public static enum IpType {
        TELCOM5("5_telcom"),
        BGP5("5_bgp"),
        SBGP5("5_sbgp"),
        LXBGP5("5_lxbgp"),
        UNION5("5_union");

        private String val;

        private IpType(String val) {
            this.val = val;
        }

        @JsonValue
        public String getVal() {
            return this.val;
        }

        @JsonCreator
        public IpType forValue(String value) {
            if (!Strings.isNullOrEmpty((String)value)) {
                for (IpType type : IpType.values()) {
                    if (!type.getVal().equalsIgnoreCase(value)) continue;
                    return type;
                }
            }
            return null;
        }
    }
}

