/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.model.scaling;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.google.common.base.Strings;
import com.huawei.openstack4j.model.ModelEntity;
import com.huawei.openstack4j.openstack.common.IdResourceEntity;
import java.util.Date;
import java.util.List;

public interface ScalingGroup
extends ModelEntity {
    public String getGroupId();

    public String getGroupName();

    public ScalingGroupStatus getGroupStatus();

    public String getConfigId();

    public String getConfigName();

    public Integer getCurrentInstanceNumber();

    public Integer getDesireInstanceNumber();

    public Integer getMinInstanceNumber();

    public Integer getMaxInstanceNumber();

    public Integer getCoolDownTime();

    public String getLbListenerId();

    public List<String> getAvailabilityZones();

    public List<IdResourceEntity> getNetworks();

    public List<IdResourceEntity> getSecurityGroups();

    public Date getCreateTime();

    public String getVpcId();

    public String getDetail();

    public Boolean getIsScaling();

    public HealthPeriodicAuditMethod getHealthPeriodicAuditMethod();

    public Integer getHealthPeriodicAuditTime();

    public InstanceTerminatePolicy getInstanceTerminatePolicy();

    public List<String> getNotifications();

    public Boolean getDeletePublicip();

    public static enum InstanceTerminatePolicy {
        OLD_CONFIG_OLD_INSTANCE,
        OLD_CONFIG_NEW_INSTANCE,
        OLD_INSTANCE,
        NEW_INSTANCE;


        @JsonCreator
        public InstanceTerminatePolicy forValue(String value) {
            if (!Strings.isNullOrEmpty((String)value)) {
                for (InstanceTerminatePolicy policy : InstanceTerminatePolicy.values()) {
                    if (!policy.name().equalsIgnoreCase(value)) continue;
                    return policy;
                }
            }
            return null;
        }
    }

    public static enum HealthPeriodicAuditMethod {
        ELB_AUDIT,
        NOVA_AUDIT;


        @JsonCreator
        public HealthPeriodicAuditMethod forValue(String value) {
            if (!Strings.isNullOrEmpty((String)value)) {
                for (HealthPeriodicAuditMethod method : HealthPeriodicAuditMethod.values()) {
                    if (!method.name().equalsIgnoreCase(value)) continue;
                    return method;
                }
            }
            return null;
        }
    }

    public static enum ScalingGroupStatus {
        INSERVICE,
        PAUSED,
        ERROR;


        @JsonCreator
        public ScalingGroupStatus forValue(String value) {
            if (!Strings.isNullOrEmpty((String)value)) {
                for (ScalingGroupStatus status : ScalingGroupStatus.values()) {
                    if (!status.name().equalsIgnoreCase(value)) continue;
                    return status;
                }
            }
            return null;
        }
    }
}

