/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.model.storage.object.options;

import com.google.common.collect.Maps;
import com.huawei.openstack4j.openstack.storage.object.functions.MetadataToHeadersFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class ObjectPutOptions {
    public static final ObjectPutOptions NONE = new ObjectPutOptions();
    Map<String, String> headers = Maps.newHashMap();
    private Map<String, List<Object>> queryParams = Maps.newHashMap();
    private String path;

    private ObjectPutOptions() {
    }

    public static ObjectPutOptions create() {
        return new ObjectPutOptions();
    }

    public ObjectPutOptions contentType(String contentType) {
        this.headers.put("Content-Type", contentType);
        return this;
    }

    public ObjectPutOptions path(String path) {
        if (path != null) {
            this.path = path.startsWith("/") ? path.substring(1) : path;
        }
        return this;
    }

    public ObjectPutOptions metadata(Map<String, String> metadata) {
        this.headers.putAll(MetadataToHeadersFunction.create("X-Object-Meta-").apply(metadata));
        return this;
    }

    public Map<String, String> getOptions() {
        return this.headers;
    }

    public String getContentType() {
        return this.headers.get("Content-Type");
    }

    public String getPath() {
        return this.path;
    }

    public ObjectPutOptions queryParam(String key, Object value) {
        if (value == null) {
            return this;
        }
        if (this.queryParams.containsKey(key)) {
            List<Object> list = this.queryParams.get(key);
            list.add(value);
        } else {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(value);
            this.queryParams.put(key, list);
        }
        return this;
    }

    public Map<String, List<Object>> getQueryParams() {
        return this.queryParams;
    }
}

