/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.model.telemetry;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.huawei.openstack4j.openstack.internal.Parser;
import java.util.Date;
import java.util.List;

public class SampleCriteria {
    private List<NameOpValue> params = Lists.newArrayList();

    public static SampleCriteria create() {
        return new SampleCriteria();
    }

    public SampleCriteria timestamp(Oper operator, Date value) {
        Preconditions.checkNotNull((Object)value, (Object)"Date must not be null");
        return this.add("timestamp", operator, Parser.toISO8601DateFormat(value));
    }

    public SampleCriteria timestamp(Oper operator, long value) {
        Preconditions.checkNotNull((Object)value, (Object)"Date must not be null");
        return this.add("timestamp", operator, Parser.toISO8601DateFormat(new Date(value)));
    }

    public SampleCriteria resource(String resourceId) {
        Preconditions.checkNotNull((Object)resourceId, (Object)"resourceId must not be null");
        return this.add("resource_id", Oper.EQUALS, resourceId);
    }

    public SampleCriteria project(String projectId) {
        Preconditions.checkNotNull((Object)projectId, (Object)"projectId must not be null");
        return this.add("project_id", Oper.EQUALS, projectId);
    }

    public SampleCriteria add(String field, Oper operator, Number value) {
        Preconditions.checkNotNull((Object)value, (Object)"Value must not be null");
        return this.add(field, operator, value.toString());
    }

    public SampleCriteria add(String field, Oper operator, String value) {
        Preconditions.checkNotNull((Object)field, (Object)"Field must not be null");
        Preconditions.checkNotNull((Object)((Object)operator), (Object)"Operator must not be null");
        Preconditions.checkNotNull((Object)value, (Object)"Value must not be null");
        this.params.add(new NameOpValue(field, operator, (Comparable<?>)((Object)value)));
        return this;
    }

    public List<NameOpValue> getCriteriaParams() {
        return this.params;
    }

    public static class NameOpValue {
        private final String field;
        private final Oper operator;
        private String value;

        NameOpValue(String field, Oper operator, Comparable<?> value) {
            this.field = field;
            this.operator = operator;
            this.value = value instanceof Date ? Parser.toISO8601DateFormat((Date)Date.class.cast(value)) : String.valueOf(value);
        }

        public String getField() {
            return this.field;
        }

        public Oper getOperator() {
            return this.operator;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum Oper {
        LT("lt"),
        GT("gt"),
        LTE("le"),
        GTE("ge"),
        EQUALS("eq");

        private final String queryValue;

        private Oper(String queryValue) {
            this.queryValue = queryValue;
        }

        public String getQueryValue() {
            return this.queryValue;
        }
    }
}

