/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack;

import com.huawei.openstack4j.api.OSClient;
import com.huawei.openstack4j.api.client.CloudProvider;
import com.huawei.openstack4j.api.client.IOSClientBuilder;
import com.huawei.openstack4j.api.exceptions.OS4JException;
import com.huawei.openstack4j.api.types.Facing;
import com.huawei.openstack4j.core.transport.Config;
import com.huawei.openstack4j.core.transport.internal.HttpLoggingFilter;
import com.huawei.openstack4j.model.identity.v2.Access;
import com.huawei.openstack4j.model.identity.v3.Token;
import com.huawei.openstack4j.openstack.client.OSClientBuilder;
import com.huawei.openstack4j.openstack.internal.OSAuthenticator;
import com.huawei.openstack4j.openstack.internal.OSClientSession;
import com.huawei.openstack4j.openstack.internal.OSClientSessionV3;

public abstract class OSFactory<T extends OSFactory<T>> {
    public static OSClient.OSClientV3 clientFromToken(Token token) {
        return OSClientSessionV3.createSession(token);
    }

    public static OSClient.OSClientV3 clientFromToken(Token token, Facing perspective) {
        return OSClientSessionV3.createSession(token, perspective, null, null);
    }

    public static OSClient.OSClientV3 clientFromToken(Token token, Config config) {
        return OSClientSessionV3.createSession(token, null, null, config);
    }

    public static OSClient.OSClientV3 clientFromToken(Token token, Facing perspective, Config config) {
        return OSClientSessionV3.createSession(token, perspective, null, config);
    }

    public static OSClient.OSClientV3 clientFromToken(Token token, Facing perspective, CloudProvider provider, Config config) {
        return OSClientSessionV3.createSession(token, perspective, provider, config);
    }

    public static OSClient.OSClientV2 clientFromAccess(Access access) {
        return OSClientSession.OSClientSessionV2.createSession(access);
    }

    public static OSClient.OSClientV2 clientFromAccess(Access access, Facing perspective) {
        return OSClientSession.OSClientSessionV2.createSession(access, perspective, null, null);
    }

    public static OSClient.OSClientV2 clientFromAccess(Access access, Config config) {
        return OSClientSession.OSClientSessionV2.createSession(access, null, null, config);
    }

    public static OSClient.OSClientV2 clientFromAccess(Access access, Facing perspective, Config config) {
        return OSClientSession.OSClientSessionV2.createSession(access, perspective, null, config);
    }

    public static OSClient.OSClientV2 clientFromAccess(Access access, Facing perspective, CloudProvider provider, Config config) {
        return OSClientSession.OSClientSessionV2.createSession(access, perspective, provider, config);
    }

    public static void enableHttpLoggingFilter(boolean enabled) {
        System.getProperties().setProperty(HttpLoggingFilter.class.getName(), String.valueOf(enabled));
    }

    public static IOSClientBuilder.V2 builderV2() {
        return new OSClientBuilder.ClientV2();
    }

    public static IOSClientBuilder.V3 builderV3() {
        return new OSClientBuilder.ClientV3();
    }

    public static IOSClientBuilder.AKSK builderAKSK() {
        return new OSClientBuilder.ClientAKSK();
    }

    public static IOSClientBuilder.TempAKSK builderTempAKSK() {
        return new OSClientBuilder.ClientTempAKSK();
    }

    public static void refreshToken() {
        OSClientSession session = OSClientSession.getCurrent();
        if (null == session) {
            throw new OS4JException("client not initialized.");
        }
        if (!(session instanceof OSClientSessionV3)) {
            throw new OS4JException("refresh token can only support token authenticate.");
        }
        OSAuthenticator.reAuthenticate();
    }
}

