/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.cdn.v1.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.huawei.openstack4j.openstack.cdn.v1.domain.Source;
import java.beans.ConstructorProperties;
import java.util.List;

@JsonRootName(value="domain")
public class DomainCreate {
    @JsonProperty(value="domain_name")
    private String domainName;
    @JsonProperty(value="business_type")
    private String businessType;
    @JsonProperty(value="enterprise_project_id")
    private String enterpriseProjectId;
    private List<Source> sources;

    @ConstructorProperties(value={"domainName", "businessType", "enterpriseProjectId", "sources"})
    DomainCreate(String domainName, String businessType, String enterpriseProjectId, List<Source> sources) {
        this.domainName = domainName;
        this.businessType = businessType;
        this.enterpriseProjectId = enterpriseProjectId;
        this.sources = sources;
    }

    public static DomainCreateBuilder builder() {
        return new DomainCreateBuilder();
    }

    public DomainCreateBuilder toBuilder() {
        return new DomainCreateBuilder().domainName(this.domainName).businessType(this.businessType).enterpriseProjectId(this.enterpriseProjectId).sources(this.sources);
    }

    public String getDomainName() {
        return this.domainName;
    }

    public String getBusinessType() {
        return this.businessType;
    }

    public String getEnterpriseProjectId() {
        return this.enterpriseProjectId;
    }

    public List<Source> getSources() {
        return this.sources;
    }

    public String toString() {
        return "DomainCreate(domainName=" + this.getDomainName() + ", businessType=" + this.getBusinessType() + ", enterpriseProjectId=" + this.getEnterpriseProjectId() + ", sources=" + this.getSources() + ")";
    }

    public static class DomainCreateBuilder {
        private String domainName;
        private String businessType;
        private String enterpriseProjectId;
        private List<Source> sources;

        DomainCreateBuilder() {
        }

        public DomainCreateBuilder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public DomainCreateBuilder businessType(String businessType) {
            this.businessType = businessType;
            return this;
        }

        public DomainCreateBuilder enterpriseProjectId(String enterpriseProjectId) {
            this.enterpriseProjectId = enterpriseProjectId;
            return this;
        }

        public DomainCreateBuilder sources(List<Source> sources) {
            this.sources = sources;
            return this;
        }

        public DomainCreate build() {
            return new DomainCreate(this.domainName, this.businessType, this.enterpriseProjectId, this.sources);
        }

        public String toString() {
            return "DomainCreate.DomainCreateBuilder(domainName=" + this.domainName + ", businessType=" + this.businessType + ", enterpriseProjectId=" + this.enterpriseProjectId + ", sources=" + this.sources + ")";
        }
    }
}

