/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.cdn.v1.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.huawei.openstack4j.model.ModelEntity;
import java.beans.ConstructorProperties;
import java.util.List;

@JsonRootName(value="log")
public class Log
implements ModelEntity {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="start_time")
    private Long startTime;
    @JsonProperty(value="end_time")
    private Long endTime;
    private String name;
    private String link;
    @JsonProperty(value="domain_name")
    private String domainName;
    private Long size;

    public static LogBuilder builder() {
        return new LogBuilder();
    }

    public LogBuilder toBuilder() {
        return new LogBuilder().startTime(this.startTime).endTime(this.endTime).name(this.name).link(this.link).domainName(this.domainName).size(this.size);
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public Long getEndTime() {
        return this.endTime;
    }

    public String getName() {
        return this.name;
    }

    public String getLink() {
        return this.link;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public Long getSize() {
        return this.size;
    }

    public String toString() {
        return "Log(startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", name=" + this.getName() + ", link=" + this.getLink() + ", domainName=" + this.getDomainName() + ", size=" + this.getSize() + ")";
    }

    public Log() {
    }

    @ConstructorProperties(value={"startTime", "endTime", "name", "link", "domainName", "size"})
    public Log(Long startTime, Long endTime, String name, String link, String domainName, Long size) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.name = name;
        this.link = link;
        this.domainName = domainName;
        this.size = size;
    }

    public static class LogBuilder {
        private Long startTime;
        private Long endTime;
        private String name;
        private String link;
        private String domainName;
        private Long size;

        LogBuilder() {
        }

        public LogBuilder startTime(Long startTime) {
            this.startTime = startTime;
            return this;
        }

        public LogBuilder endTime(Long endTime) {
            this.endTime = endTime;
            return this;
        }

        public LogBuilder name(String name) {
            this.name = name;
            return this;
        }

        public LogBuilder link(String link) {
            this.link = link;
            return this;
        }

        public LogBuilder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public LogBuilder size(Long size) {
            this.size = size;
            return this;
        }

        public Log build() {
            return new Log(this.startTime, this.endTime, this.name, this.link, this.domainName, this.size);
        }

        public String toString() {
            return "Log.LogBuilder(startTime=" + this.startTime + ", endTime=" + this.endTime + ", name=" + this.name + ", link=" + this.link + ", domainName=" + this.domainName + ", size=" + this.size + ")";
        }
    }

    public static class Logs {
        List<Log> logs;
        Integer total;

        public Integer getTotal() {
            return this.total;
        }

        public List<Log> getLogs() {
            return this.logs;
        }

        public Logs() {
        }

        @ConstructorProperties(value={"logs", "total"})
        public Logs(List<Log> logs, Integer total) {
            this.logs = logs;
            this.total = total;
        }

        public String toString() {
            return "Log.Logs(logs=" + this.getLogs() + ", total=" + this.getTotal() + ")";
        }
    }
}

