/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.cdn.v1.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.huawei.openstack4j.model.ModelEntity;
import com.huawei.openstack4j.openstack.common.ListResult;
import java.beans.ConstructorProperties;
import java.util.List;

@JsonRootName(value="source")
public class Source
implements ModelEntity {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="domain_id")
    private String domainId;
    @JsonProperty(value="ip_or_domain")
    private String ipOrDomain;
    @JsonProperty(value="origin_type")
    private String originType;
    @JsonProperty(value="active_standby")
    private Integer activeStandby;

    public static SourceBuilder builder() {
        return new SourceBuilder();
    }

    public SourceBuilder toBuilder() {
        return new SourceBuilder().domainId(this.domainId).ipOrDomain(this.ipOrDomain).originType(this.originType).activeStandby(this.activeStandby);
    }

    public String getDomainId() {
        return this.domainId;
    }

    public String getIpOrDomain() {
        return this.ipOrDomain;
    }

    public String getOriginType() {
        return this.originType;
    }

    public Integer getActiveStandby() {
        return this.activeStandby;
    }

    public String toString() {
        return "Source(domainId=" + this.getDomainId() + ", ipOrDomain=" + this.getIpOrDomain() + ", originType=" + this.getOriginType() + ", activeStandby=" + this.getActiveStandby() + ")";
    }

    public Source() {
    }

    @ConstructorProperties(value={"domainId", "ipOrDomain", "originType", "activeStandby"})
    public Source(String domainId, String ipOrDomain, String originType, Integer activeStandby) {
        this.domainId = domainId;
        this.ipOrDomain = ipOrDomain;
        this.originType = originType;
        this.activeStandby = activeStandby;
    }

    public static class SourceBuilder {
        private String domainId;
        private String ipOrDomain;
        private String originType;
        private Integer activeStandby;

        SourceBuilder() {
        }

        public SourceBuilder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public SourceBuilder ipOrDomain(String ipOrDomain) {
            this.ipOrDomain = ipOrDomain;
            return this;
        }

        public SourceBuilder originType(String originType) {
            this.originType = originType;
            return this;
        }

        public SourceBuilder activeStandby(Integer activeStandby) {
            this.activeStandby = activeStandby;
            return this;
        }

        public Source build() {
            return new Source(this.domainId, this.ipOrDomain, this.originType, this.activeStandby);
        }

        public String toString() {
            return "Source.SourceBuilder(domainId=" + this.domainId + ", ipOrDomain=" + this.ipOrDomain + ", originType=" + this.originType + ", activeStandby=" + this.activeStandby + ")";
        }
    }

    @JsonRootName(value="origin")
    public static class Origin {
        @JsonProperty(value="sources")
        List<Source> sources;

        public List<Source> getSources() {
            return this.sources;
        }

        public static OriginBuilder builder() {
            return new OriginBuilder();
        }

        public OriginBuilder toBuilder() {
            return new OriginBuilder().sources(this.sources);
        }

        public Origin() {
        }

        @ConstructorProperties(value={"sources"})
        public Origin(List<Source> sources) {
            this.sources = sources;
        }

        public static class OriginBuilder {
            private List<Source> sources;

            OriginBuilder() {
            }

            public OriginBuilder sources(List<Source> sources) {
                this.sources = sources;
                return this;
            }

            public Origin build() {
                return new Origin(this.sources);
            }

            public String toString() {
                return "Source.Origin.OriginBuilder(sources=" + this.sources + ")";
            }
        }
    }

    public static class Sources
    extends ListResult<Source> {
        private static final long serialVersionUID = 7666104777418585874L;
        @JsonProperty(value="sources")
        List<Source> sources;

        @Override
        protected List<Source> value() {
            return this.sources;
        }
    }
}

