/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.cdn.v1.internal;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.common.base.Function;
import com.google.common.io.CharStreams;
import com.huawei.openstack4j.api.types.ServiceType;
import com.huawei.openstack4j.core.transport.Config;
import com.huawei.openstack4j.core.transport.ExecutionOptions;
import com.huawei.openstack4j.core.transport.HttpMethod;
import com.huawei.openstack4j.core.transport.HttpResponse;
import com.huawei.openstack4j.core.transport.ObjectMapperSingleton;
import com.huawei.openstack4j.openstack.cdn.v1.domain.CdnError;
import com.huawei.openstack4j.openstack.cdn.v1.exception.ServerCdnErrorResponseException;
import com.huawei.openstack4j.openstack.internal.BaseOpenStackService;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseCdnServices
extends BaseOpenStackService {
    private static final Logger LOG = LoggerFactory.getLogger(BaseCdnServices.class);

    public BaseCdnServices() {
        super(ServiceType.CDN);
    }

    @Override
    protected <R> BaseOpenStackService.Invocation<R> builder(Class<R> returnType, String path, HttpMethod method) {
        path = "/cdn" + path;
        BaseOpenStackService.Invocation<R> invocation = super.builder(returnType, path, method);
        Config config = invocation.getRequest().getConfig();
        return invocation.header("Content-Type", CONTENT_JSON).header("X-Language", config.getLanguage());
    }

    protected <T> ExecutionOptions<T> buildExecutionOptions(final Class<T> returnType) {
        Function f = new Function<HttpResponse, T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public T apply(HttpResponse response) {
                InputStream inputStream = response.getInputStream();
                String json = "";
                try {
                    json = CharStreams.toString((Readable)new InputStreamReader(inputStream, "UTF-8"));
                    Object object = ObjectMapperSingleton.getContext(returnType).readValue(json, returnType);
                    return object;
                }
                catch (Exception e) {
                    try {
                        CdnError error = (CdnError)ObjectMapperSingleton.getContext(CdnError.class).readValue(json, CdnError.class);
                        throw new ServerCdnErrorResponseException(error.getErrorMsg(), error.getErrorCode());
                    }
                    catch (JsonParseException e1) {
                        LOG.error(e1.getMessage());
                    }
                    catch (JsonMappingException e1) {
                        LOG.error(e1.getMessage());
                    }
                    catch (IOException e1) {
                        LOG.error(e1.getMessage());
                    }
                    LOG.error(e.getMessage());
                }
                finally {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        LOG.error(e.getMessage());
                    }
                }
                return null;
            }
        };
        return ExecutionOptions.create(f);
    }
}

