/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.cdn.v1.internal;

import com.google.common.base.Preconditions;
import com.huawei.openstack4j.openstack.cdn.v1.domain.CacheConfig;
import com.huawei.openstack4j.openstack.cdn.v1.domain.CdnIP;
import com.huawei.openstack4j.openstack.cdn.v1.domain.Domain;
import com.huawei.openstack4j.openstack.cdn.v1.domain.DomainCreate;
import com.huawei.openstack4j.openstack.cdn.v1.domain.HttpsInfo;
import com.huawei.openstack4j.openstack.cdn.v1.domain.OriginHost;
import com.huawei.openstack4j.openstack.cdn.v1.domain.PreheatingTask;
import com.huawei.openstack4j.openstack.cdn.v1.domain.PreheatingTaskCreate;
import com.huawei.openstack4j.openstack.cdn.v1.domain.Referer;
import com.huawei.openstack4j.openstack.cdn.v1.domain.RefreshTask;
import com.huawei.openstack4j.openstack.cdn.v1.domain.RefreshTaskCreate;
import com.huawei.openstack4j.openstack.cdn.v1.domain.Source;
import com.huawei.openstack4j.openstack.cdn.v1.domain.Task;
import com.huawei.openstack4j.openstack.cdn.v1.domain.TaskDetail;
import com.huawei.openstack4j.openstack.cdn.v1.exception.ServerCdnErrorResponseException;
import com.huawei.openstack4j.openstack.cdn.v1.internal.BaseCdnServices;
import com.huawei.openstack4j.openstack.internal.BaseOpenStackService;
import java.util.Map;

public class DomainService
extends BaseCdnServices {
    public Domain.Domains list(Map<String, String> params) {
        Preconditions.checkNotNull((Object)params.get("page_size"), (Object)"parameter `page_size` should not be null");
        Preconditions.checkNotNull((Object)params.get("page_number"), (Object)"parameter `page_number` should not be null");
        BaseOpenStackService.Invocation<Domain.Domains> domainInvocation = this.get(Domain.Domains.class, this.uri("/domains", new Object[0]));
        if (params != null) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                domainInvocation = domainInvocation.param(entry.getKey(), entry.getValue());
            }
        }
        return domainInvocation.execute(this.buildExecutionOptions(Domain.Domains.class));
    }

    public Domain create(DomainCreate creation) throws ServerCdnErrorResponseException {
        Preconditions.checkNotNull((Object)creation, (Object)"parameter `creation` should not be null");
        Preconditions.checkNotNull((Object)creation.getBusinessType(), (Object)"parameter `business_type` should not be null");
        Preconditions.checkNotNull((Object)creation.getDomainName(), (Object)"parameter `domain_name` should not be null");
        Preconditions.checkNotNull(creation.getSources(), (Object)"parameter `creation.sources` should not be empty");
        Preconditions.checkNotNull((Object)creation.getSources().get(0).getIpOrDomain(), (Object)"parameter `ip_or_domain` should not be empty");
        return this.post(Domain.class, this.uri("/domains", new Object[0])).entity(creation).execute(this.buildExecutionOptions(Domain.class));
    }

    public Domain delete(String domainId, Map<String, String> params) throws ServerCdnErrorResponseException {
        Preconditions.checkNotNull((Object)domainId, (Object)"parameter `domainId` should not be null");
        BaseOpenStackService.Invocation<Domain> domainInvocation = this.delete(Domain.class, this.uri("/domains/%s", domainId));
        if (params != null) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                domainInvocation = domainInvocation.param(entry.getKey(), entry.getValue());
            }
        }
        return domainInvocation.execute(this.buildExecutionOptions(Domain.class));
    }

    public Domain enable(String domainId, Map<String, String> params) throws ServerCdnErrorResponseException {
        Preconditions.checkNotNull((Object)domainId, (Object)"parameter `domainId` should not be null");
        BaseOpenStackService.Invocation<Domain> domainInvocation = this.put(Domain.class, this.uri("/domains/%s/enable", domainId));
        if (params != null) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                domainInvocation = domainInvocation.param(entry.getKey(), entry.getValue());
            }
        }
        return domainInvocation.execute(this.buildExecutionOptions(Domain.class));
    }

    public Domain disable(String domainId, Map<String, String> params) throws ServerCdnErrorResponseException {
        Preconditions.checkNotNull((Object)domainId, (Object)"parameter `domainId` should not be null");
        BaseOpenStackService.Invocation<Domain> domainInvocation = this.put(Domain.class, this.uri("/domains/%s/disable", domainId));
        if (params != null) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                domainInvocation = domainInvocation.param(entry.getKey(), entry.getValue());
            }
        }
        return domainInvocation.execute(this.buildExecutionOptions(Domain.class));
    }

    public Domain getDetail(String domainId, Map<String, String> params) throws ServerCdnErrorResponseException {
        Preconditions.checkNotNull((Object)domainId, (Object)"parameter `domainId` should not be null");
        BaseOpenStackService.Invocation<Domain> domainInvocation = this.get(Domain.class, this.uri("/domains/%s/detail", domainId));
        if (params != null) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                domainInvocation = domainInvocation.param(entry.getKey(), entry.getValue());
            }
        }
        return domainInvocation.execute(this.buildExecutionOptions(Domain.class));
    }

    public Source.Origin setOrigin(String domainId, Source.Origin origin, Map<String, String> params) throws ServerCdnErrorResponseException {
        Preconditions.checkNotNull((Object)domainId, (Object)"parameter `domainId` should not be null");
        Preconditions.checkNotNull((Object)origin, (Object)"parameter `origin` should not be null");
        BaseOpenStackService.Invocation<Source.Origin> domainInvocation = this.put(Source.Origin.class, this.uri("/domains/%s/origin", domainId)).entity(origin);
        if (params != null) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                domainInvocation = domainInvocation.param(entry.getKey(), entry.getValue());
            }
        }
        return domainInvocation.execute(this.buildExecutionOptions(Source.Origin.class));
    }

    public OriginHost getOriginHost(String domainId, Map<String, String> params) throws ServerCdnErrorResponseException {
        Preconditions.checkNotNull((Object)domainId, (Object)"parameter `domainId` should not be null");
        BaseOpenStackService.Invocation<OriginHost> domainInvocation = this.get(OriginHost.class, this.uri("/domains/%s/originhost", domainId));
        if (params != null) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                domainInvocation = domainInvocation.param(entry.getKey(), entry.getValue());
            }
        }
        return domainInvocation.execute(this.buildExecutionOptions(OriginHost.class));
    }

    public OriginHost setOriginHost(String domainId, OriginHost originHost, Map<String, String> params) throws ServerCdnErrorResponseException {
        Preconditions.checkNotNull((Object)domainId, (Object)"parameter `domainId` should not be null");
        Preconditions.checkNotNull((Object)originHost, (Object)"parameter `originHost` should not be null");
        Preconditions.checkNotNull((Object)originHost.getOriginHostType(), (Object)"parameter `origin_host_type` should not be null");
        BaseOpenStackService.Invocation<OriginHost> domainInvocation = this.put(OriginHost.class, this.uri("/domains/%s/originhost", domainId)).entity(originHost);
        if (params != null) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                domainInvocation = domainInvocation.param(entry.getKey(), entry.getValue());
            }
        }
        return domainInvocation.execute(this.buildExecutionOptions(OriginHost.class));
    }

    public Referer setReferer(String domainId, Referer referer, Map<String, String> params) throws ServerCdnErrorResponseException {
        Preconditions.checkNotNull((Object)domainId, (Object)"parameter `domainId` should not be null");
        Preconditions.checkNotNull((Object)referer, (Object)"parameter `referer` should not be null");
        Preconditions.checkNotNull((Object)referer.getRefererType(), (Object)"parameter `referer_type` should not be null");
        BaseOpenStackService.Invocation<Referer> domainInvocation = this.put(Referer.class, this.uri("/domains/%s/referer", domainId)).entity(referer);
        if (params != null) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                domainInvocation = domainInvocation.param(entry.getKey(), entry.getValue());
            }
        }
        return domainInvocation.execute(this.buildExecutionOptions(Referer.class));
    }

    public Referer getReferer(String domainId, Map<String, String> params) throws ServerCdnErrorResponseException {
        Preconditions.checkNotNull((Object)domainId, (Object)"parameter `domainId` should not be null");
        BaseOpenStackService.Invocation<Referer> domainInvocation = this.get(Referer.class, this.uri("/domains/%s/referer", domainId));
        if (params != null) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                domainInvocation = domainInvocation.param(entry.getKey(), entry.getValue());
            }
        }
        return domainInvocation.execute(this.buildExecutionOptions(Referer.class));
    }

    public CacheConfig setCacheConfig(String domainId, CacheConfig cacheConfig, Map<String, String> params) throws ServerCdnErrorResponseException {
        Preconditions.checkNotNull((Object)domainId, (Object)"parameter `domainId` should not be null");
        Preconditions.checkNotNull((Object)cacheConfig, (Object)"parameter `cacheConfig` should not be null");
        BaseOpenStackService.Invocation<CacheConfig> domainInvocation = this.put(CacheConfig.class, this.uri("/domains/%s/cache", domainId)).entity(cacheConfig);
        if (params != null) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                domainInvocation = domainInvocation.param(entry.getKey(), entry.getValue());
            }
        }
        return domainInvocation.execute(this.buildExecutionOptions(CacheConfig.class));
    }

    public CacheConfig getCacheConfig(String domainId, Map<String, String> params) throws ServerCdnErrorResponseException {
        Preconditions.checkNotNull((Object)domainId, (Object)"parameter `domainId` should not be null");
        BaseOpenStackService.Invocation<CacheConfig> domainInvocation = this.get(CacheConfig.class, this.uri("/domains/%s/cache", domainId));
        if (params != null) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                domainInvocation = domainInvocation.param(entry.getKey(), entry.getValue());
            }
        }
        return domainInvocation.execute(this.buildExecutionOptions(CacheConfig.class));
    }

    public HttpsInfo setHttpsInfo(String domainId, HttpsInfo httpsInfo, Map<String, String> params) throws ServerCdnErrorResponseException {
        Preconditions.checkNotNull((Object)domainId, (Object)"parameter `domainId` should not be null");
        Preconditions.checkNotNull((Object)httpsInfo, (Object)"parameter `httpsInfo` should not be null");
        Preconditions.checkNotNull((Object)httpsInfo.getCertName(), (Object)"parameter `cert_name` should not be null");
        Preconditions.checkNotNull((Object)httpsInfo.getHttpsStatus(), (Object)"parameter `https_status` should not be null");
        BaseOpenStackService.Invocation<HttpsInfo> domainInvocation = this.put(HttpsInfo.class, this.uri("/domains/%s/https-info", domainId)).entity(httpsInfo);
        if (params != null) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                domainInvocation = domainInvocation.param(entry.getKey(), entry.getValue());
            }
        }
        return domainInvocation.execute(this.buildExecutionOptions(HttpsInfo.class));
    }

    public HttpsInfo getHttpsInfo(String domainId, Map<String, String> params) throws ServerCdnErrorResponseException {
        Preconditions.checkNotNull((Object)domainId, (Object)"parameter `domainId` should not be null");
        BaseOpenStackService.Invocation<HttpsInfo> domainInvocation = this.get(HttpsInfo.class, this.uri("/domains/%s/https-info", domainId));
        if (params != null) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                domainInvocation = domainInvocation.param(entry.getKey(), entry.getValue());
            }
        }
        return domainInvocation.execute(this.buildExecutionOptions(HttpsInfo.class));
    }

    public RefreshTask createRefreshTask(RefreshTaskCreate creation, Map<String, String> params) throws ServerCdnErrorResponseException {
        Preconditions.checkNotNull((Object)creation, (Object)"parameter `creation` should not be null");
        Preconditions.checkNotNull(creation.getUrls(), (Object)"parameter `urls` should not be null");
        BaseOpenStackService.Invocation<RefreshTask> domainInvocation = this.post(RefreshTask.class, this.uri("/refreshtasks", new Object[0])).entity(creation);
        if (params != null) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                domainInvocation = domainInvocation.param(entry.getKey(), entry.getValue());
            }
        }
        return domainInvocation.execute(this.buildExecutionOptions(RefreshTask.class));
    }

    public PreheatingTask createPreheatingTask(PreheatingTaskCreate creation, Map<String, String> params) throws ServerCdnErrorResponseException {
        Preconditions.checkNotNull((Object)creation, (Object)"parameter `creation` should not be null");
        Preconditions.checkNotNull(creation.getUrls(), (Object)"parameter `urls` should not be null");
        BaseOpenStackService.Invocation<PreheatingTask> domainInvocation = this.post(PreheatingTask.class, this.uri("/preheatingtasks", new Object[0])).entity(creation);
        if (params != null) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                domainInvocation = domainInvocation.param(entry.getKey(), entry.getValue());
            }
        }
        return domainInvocation.execute(this.buildExecutionOptions(PreheatingTask.class));
    }

    public Task.Tasks queryTasks(Map<String, String> params) throws ServerCdnErrorResponseException {
        Preconditions.checkNotNull((Object)params.get("page_size"), (Object)"parameter `page_size` should not be null");
        Preconditions.checkNotNull((Object)params.get("page_number"), (Object)"parameter `page_number` should not be null");
        BaseOpenStackService.Invocation<Task.Tasks> taskInvocation = this.get(Task.Tasks.class, this.uri("/historytasks", new Object[0]));
        if (params != null) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                taskInvocation = taskInvocation.param(entry.getKey(), entry.getValue());
            }
        }
        return taskInvocation.execute(this.buildExecutionOptions(Task.Tasks.class));
    }

    public TaskDetail getTaskDetail(String taskId, Map<String, String> params) throws ServerCdnErrorResponseException {
        Preconditions.checkNotNull((Object)taskId, (Object)"parameter `taskId` should not be null");
        Preconditions.checkNotNull((Object)params.get("page_size"), (Object)"parameter `pageSize` should not be null");
        Preconditions.checkNotNull((Object)params.get("page_number"), (Object)"parameter `pageNumber` should not be null");
        BaseOpenStackService.Invocation<TaskDetail> taskDetailInvocation = this.get(TaskDetail.class, this.uri("/historytasks/%s/detail", taskId));
        if (params != null) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                taskDetailInvocation = taskDetailInvocation.param(entry.getKey(), entry.getValue());
            }
        }
        return taskDetailInvocation.execute(this.buildExecutionOptions(TaskDetail.class));
    }

    public CdnIP.CdnIPs queryCdnIPs(Map<String, String> params) throws ServerCdnErrorResponseException {
        Preconditions.checkNotNull((Object)params.get("ips"), (Object)"parameter `ips` should not be null");
        BaseOpenStackService.Invocation<CdnIP.CdnIPs> cdnIPsInvocation = this.get(CdnIP.CdnIPs.class, this.uri("/ip-info", new Object[0]));
        if (params != null) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                cdnIPsInvocation = cdnIPsInvocation.param(entry.getKey(), entry.getValue());
            }
        }
        return cdnIPsInvocation.execute(this.buildExecutionOptions(CdnIP.CdnIPs.class));
    }
}

