/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.cloud.trace.v1.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.huawei.openstack4j.model.ModelEntity;
import com.huawei.openstack4j.openstack.cloud.trace.constants.TrackerStatus;
import java.beans.ConstructorProperties;

public class TrackerUpdate
implements ModelEntity {
    private static final long serialVersionUID = -6764087311133427927L;
    @JsonIgnore
    String trackerName;
    @JsonProperty(value="bucket_name")
    String bucketName;
    @JsonProperty(value="file_prefix_name")
    String filePrefixName;
    @JsonProperty(value="status")
    TrackerStatus status;

    public static TrackerUpdateBuilder builder() {
        return new TrackerUpdateBuilder();
    }

    public TrackerUpdateBuilder toBuilder() {
        return new TrackerUpdateBuilder().trackerName(this.trackerName).bucketName(this.bucketName).filePrefixName(this.filePrefixName).status(this.status);
    }

    public String getTrackerName() {
        return this.trackerName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getFilePrefixName() {
        return this.filePrefixName;
    }

    public TrackerStatus getStatus() {
        return this.status;
    }

    public String toString() {
        return "TrackerUpdate(trackerName=" + this.getTrackerName() + ", bucketName=" + this.getBucketName() + ", filePrefixName=" + this.getFilePrefixName() + ", status=" + (Object)((Object)this.getStatus()) + ")";
    }

    public TrackerUpdate() {
    }

    @ConstructorProperties(value={"trackerName", "bucketName", "filePrefixName", "status"})
    public TrackerUpdate(String trackerName, String bucketName, String filePrefixName, TrackerStatus status) {
        this.trackerName = trackerName;
        this.bucketName = bucketName;
        this.filePrefixName = filePrefixName;
        this.status = status;
    }

    public static class TrackerUpdateBuilder {
        private String trackerName;
        private String bucketName;
        private String filePrefixName;
        private TrackerStatus status;

        TrackerUpdateBuilder() {
        }

        public TrackerUpdateBuilder trackerName(String trackerName) {
            this.trackerName = trackerName;
            return this;
        }

        public TrackerUpdateBuilder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public TrackerUpdateBuilder filePrefixName(String filePrefixName) {
            this.filePrefixName = filePrefixName;
            return this;
        }

        public TrackerUpdateBuilder status(TrackerStatus status) {
            this.status = status;
            return this;
        }

        public TrackerUpdate build() {
            return new TrackerUpdate(this.trackerName, this.bucketName, this.filePrefixName, this.status);
        }

        public String toString() {
            return "TrackerUpdate.TrackerUpdateBuilder(trackerName=" + this.trackerName + ", bucketName=" + this.bucketName + ", filePrefixName=" + this.filePrefixName + ", status=" + (Object)((Object)this.status) + ")";
        }
    }
}

