/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.cloud.trace.v1.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.huawei.openstack4j.common.RestService;
import com.huawei.openstack4j.core.transport.ExecutionOptions;
import com.huawei.openstack4j.core.transport.propagation.PropagateOnStatus;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.openstack.cloud.trace.v1.domain.Tracker;
import com.huawei.openstack4j.openstack.cloud.trace.v1.domain.TrackerUpdate;
import com.huawei.openstack4j.openstack.cloud.trace.v1.internal.BaseCloudTraceServices;
import java.util.HashMap;
import java.util.List;

public class TrackerService
extends BaseCloudTraceServices
implements RestService {
    public List<Tracker> list() {
        return this.get(Tracker.Trackers.class, "/tracker").execute().getList();
    }

    public Tracker get(String trackerName) {
        Preconditions.checkNotNull((Object)trackerName, (Object)"parameter `trackerName` should not be empty");
        return this.get(Tracker.class, "/tracker").param("tracker_name", trackerName).execute();
    }

    public Tracker create(String bucketName) {
        return this.create(bucketName, null);
    }

    public Tracker create(String bucketName, String filePrefixName) {
        Preconditions.checkNotNull((Object)bucketName, (Object)"parameter `bucketName` should not be empty");
        HashMap entity = Maps.newHashMap();
        entity.put("bucket_name", bucketName);
        if (!Strings.isNullOrEmpty((String)filePrefixName)) {
            entity.put("file_prefix_name", filePrefixName);
        }
        return this.post(Tracker.class, "/tracker").entity(entity).execute(ExecutionOptions.create(PropagateOnStatus.on(404)));
    }

    public Tracker update(TrackerUpdate update) {
        Preconditions.checkNotNull((Object)update, (Object)"parameter `update` should not be empty");
        Preconditions.checkNotNull((Object)update.getTrackerName(), (Object)"parameter `update.tracerName` should not be empty");
        Preconditions.checkNotNull((Object)update.getBucketName(), (Object)"parameter `update.bucketName` should not be empty");
        String trackerName = update.getTrackerName();
        update = update.toBuilder().trackerName(null).build();
        return this.put(Tracker.class, "/tracker/", trackerName).entity(update).execute(ExecutionOptions.create(PropagateOnStatus.on(404)));
    }

    public ActionResponse delete(String trackerName) {
        Preconditions.checkNotNull((Object)trackerName, (Object)"parameter `trackerName` should not be empty");
        return this.deleteWithResponse("/tracker").param("tracker_name", trackerName).execute();
    }

    public ActionResponse deleteAll() {
        return this.deleteWithResponse("/tracker").execute();
    }
}

