/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.cloudeye.internal;

import com.google.common.base.Preconditions;
import com.huawei.openstack4j.api.cloudeye.MetricDataService;
import com.huawei.openstack4j.model.cloudeye.Filter;
import com.huawei.openstack4j.model.cloudeye.MetricAggregation;
import com.huawei.openstack4j.model.cloudeye.MetricData;
import com.huawei.openstack4j.model.cloudeye.Period;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.openstack.cloudeye.domain.CloudEyeMetricAggregation;
import com.huawei.openstack4j.openstack.cloudeye.internal.BaseCloudEyeServices;
import com.huawei.openstack4j.openstack.internal.BaseOpenStackService;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class CloudEyeMetricDataServiceImpl
extends BaseCloudEyeServices
implements MetricDataService {
    @Override
    public MetricAggregation get(String namespace, String metric_name, Date from, Date to, Period period, Filter filter, String[] dimValues) {
        Preconditions.checkNotNull((Object)namespace);
        Preconditions.checkNotNull((Object)metric_name);
        Preconditions.checkNotNull((Object)from);
        Preconditions.checkNotNull((Object)to);
        Preconditions.checkNotNull((Object)((Object)period));
        Preconditions.checkNotNull((Object)((Object)filter));
        Preconditions.checkNotNull((Object)dimValues);
        BaseOpenStackService.Invocation<CloudEyeMetricAggregation> invocation = this.get(CloudEyeMetricAggregation.class, this.uri("/metric-data", new Object[0]));
        HashMap<String, Object> filters = new HashMap<String, Object>();
        filters.put("namespace", namespace);
        filters.put("metric_name", metric_name);
        filters.put("from", from.getTime());
        filters.put("to", to.getTime());
        filters.put("period", period.getCode());
        filters.put("filter", filter.value());
        for (int i = 0; i < dimValues.length; ++i) {
            filters.put("dim." + i, dimValues[i]);
        }
        invocation.params(filters);
        return invocation.execute();
    }

    @Override
    public ActionResponse add(List<? extends MetricData> metrics) {
        Preconditions.checkNotNull(metrics);
        return this.postWithResponse("/metric-data").entity(metrics).execute();
    }
}

