/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.common;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.huawei.openstack4j.model.common.Link;
import com.huawei.openstack4j.model.common.builder.LinkBuilder;

public class GenericLink
implements Link {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="rel")
    private String rel;
    @JsonProperty(value="href")
    private String href;
    @JsonProperty(value="type")
    private String type;

    public static LinkBuilder builder() {
        return new LinkConcreteBuilder();
    }

    @Override
    public LinkBuilder toBuilder() {
        return new LinkConcreteBuilder(this);
    }

    @Override
    public String getRel() {
        return this.rel;
    }

    @Override
    public String getHref() {
        return this.href;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("href", (Object)this.href).add("rel", (Object)this.rel).add("type", (Object)this.type).toString();
    }

    public static class LinkConcreteBuilder
    implements LinkBuilder {
        GenericLink model;

        LinkConcreteBuilder() {
            this(new GenericLink());
        }

        LinkConcreteBuilder(GenericLink link) {
            this.model = link;
        }

        @Override
        public LinkConcreteBuilder rel(String rel) {
            this.model.rel = rel;
            return this;
        }

        @Override
        public LinkConcreteBuilder href(String href) {
            this.model.href = href;
            return this;
        }

        @Override
        public LinkConcreteBuilder type(String type) {
            this.model.type = type;
            return this;
        }

        @Override
        public Link build() {
            return this.model;
        }

        @Override
        public LinkBuilder from(Link in) {
            this.model = (GenericLink)in;
            return this;
        }
    }
}

