/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.huawei.openstack4j.model.ModelEntity;
import com.huawei.openstack4j.openstack.common.ListResult;
import java.beans.ConstructorProperties;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Quota
implements ModelEntity {
    private static final long serialVersionUID = 8118640445519970866L;
    ResourceType type;
    Integer used;
    Integer quota;
    String unit;
    Integer max;
    Integer min;

    public static QuotaBuilder builder() {
        return new QuotaBuilder();
    }

    public QuotaBuilder toBuilder() {
        return new QuotaBuilder().type(this.type).used(this.used).quota(this.quota).unit(this.unit).max(this.max).min(this.min);
    }

    public ResourceType getType() {
        return this.type;
    }

    public Integer getUsed() {
        return this.used;
    }

    public Integer getQuota() {
        return this.quota;
    }

    public String getUnit() {
        return this.unit;
    }

    public Integer getMax() {
        return this.max;
    }

    public Integer getMin() {
        return this.min;
    }

    public String toString() {
        return "Quota(type=" + (Object)((Object)this.getType()) + ", used=" + this.getUsed() + ", quota=" + this.getQuota() + ", unit=" + this.getUnit() + ", max=" + this.getMax() + ", min=" + this.getMin() + ")";
    }

    public Quota() {
    }

    @ConstructorProperties(value={"type", "used", "quota", "unit", "max", "min"})
    public Quota(ResourceType type, Integer used, Integer quota, String unit, Integer max, Integer min) {
        this.type = type;
        this.used = used;
        this.quota = quota;
        this.unit = unit;
        this.max = max;
        this.min = min;
    }

    public static class QuotaBuilder {
        private ResourceType type;
        private Integer used;
        private Integer quota;
        private String unit;
        private Integer max;
        private Integer min;

        QuotaBuilder() {
        }

        public QuotaBuilder type(ResourceType type) {
            this.type = type;
            return this;
        }

        public QuotaBuilder used(Integer used) {
            this.used = used;
            return this;
        }

        public QuotaBuilder quota(Integer quota) {
            this.quota = quota;
            return this;
        }

        public QuotaBuilder unit(String unit) {
            this.unit = unit;
            return this;
        }

        public QuotaBuilder max(Integer max) {
            this.max = max;
            return this;
        }

        public QuotaBuilder min(Integer min) {
            this.min = min;
            return this;
        }

        public Quota build() {
            return new Quota(this.type, this.used, this.quota, this.unit, this.max, this.min);
        }

        public String toString() {
            return "Quota.QuotaBuilder(type=" + (Object)((Object)this.type) + ", used=" + this.used + ", quota=" + this.quota + ", unit=" + this.unit + ", max=" + this.max + ", min=" + this.min + ")";
        }
    }

    @JsonRootName(value="quotas")
    public static class Quotas
    extends ListResult<Quota> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="resources")
        private List<Quota> resources;

        @Override
        public List<Quota> value() {
            return this.resources;
        }
    }

    public static enum ResourceType {
        ALARM,
        CMK,
        GRANT_PER_CMK,
        QUEUE,
        ELB,
        LISTENER,
        SCALING_GROUP,
        SCALING_CONFIG,
        SCALING_POLICY,
        SCALING_INSTANCE;


        @JsonCreator
        public static ResourceType value(String v) {
            try {
                return ResourceType.valueOf(v.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
    }
}

