/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.huawei.openstack4j.model.ModelEntity;
import com.huawei.openstack4j.openstack.common.GenericLink;
import com.huawei.openstack4j.openstack.common.ListResult;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.List;

public class ServiceVersion
implements ModelEntity {
    static final long serialVersionUID = -3477831655673026786L;
    @JsonProperty(value="id")
    String id;
    @JsonProperty(value="links")
    List<GenericLink> links;
    @JsonProperty(value="status")
    ServiceStatus status;
    @JsonProperty(value="updated")
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss'Z'")
    Date updated;

    public static ServiceVersionBuilder builder() {
        return new ServiceVersionBuilder();
    }

    public ServiceVersionBuilder toBuilder() {
        return new ServiceVersionBuilder().id(this.id).links(this.links).status(this.status).updated(this.updated);
    }

    public String getId() {
        return this.id;
    }

    public List<GenericLink> getLinks() {
        return this.links;
    }

    public ServiceStatus getStatus() {
        return this.status;
    }

    public Date getUpdated() {
        return this.updated;
    }

    public String toString() {
        return "ServiceVersion(id=" + this.getId() + ", links=" + this.getLinks() + ", status=" + (Object)((Object)this.getStatus()) + ", updated=" + this.getUpdated() + ")";
    }

    public ServiceVersion() {
    }

    @ConstructorProperties(value={"id", "links", "status", "updated"})
    public ServiceVersion(String id, List<GenericLink> links, ServiceStatus status, Date updated) {
        this.id = id;
        this.links = links;
        this.status = status;
        this.updated = updated;
    }

    public static class ServiceVersionBuilder {
        private String id;
        private List<GenericLink> links;
        private ServiceStatus status;
        private Date updated;

        ServiceVersionBuilder() {
        }

        public ServiceVersionBuilder id(String id) {
            this.id = id;
            return this;
        }

        public ServiceVersionBuilder links(List<GenericLink> links) {
            this.links = links;
            return this;
        }

        public ServiceVersionBuilder status(ServiceStatus status) {
            this.status = status;
            return this;
        }

        public ServiceVersionBuilder updated(Date updated) {
            this.updated = updated;
            return this;
        }

        public ServiceVersion build() {
            return new ServiceVersion(this.id, this.links, this.status, this.updated);
        }

        public String toString() {
            return "ServiceVersion.ServiceVersionBuilder(id=" + this.id + ", links=" + this.links + ", status=" + (Object)((Object)this.status) + ", updated=" + this.updated + ")";
        }
    }

    public static class ServiceVersions
    extends ListResult<ServiceVersion> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="versions")
        private List<ServiceVersion> versions;

        @Override
        public List<ServiceVersion> value() {
            return this.versions;
        }
    }

    public static class ServiceVersionWrap {
        @JsonProperty(value="version")
        private ServiceVersion version;

        public ServiceVersion getVersion() {
            return this.version;
        }

        public void setVersion(ServiceVersion version) {
            this.version = version;
        }
    }

    public static enum ServiceStatus {
        DEPRECATED,
        CURRENT,
        STABLE;


        @JsonCreator
        public static ServiceStatus forValue(String value) {
            if (value != null) {
                for (ServiceStatus state : ServiceStatus.values()) {
                    if (!value.equalsIgnoreCase(state.name())) continue;
                    return state;
                }
            }
            return null;
        }
    }
}

