/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.compute.domain;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.huawei.openstack4j.model.compute.BDMDestType;
import com.huawei.openstack4j.model.compute.BDMSourceType;
import com.huawei.openstack4j.model.compute.BDMVolumeType;
import com.huawei.openstack4j.model.compute.BlockDeviceMappingCreate;
import com.huawei.openstack4j.model.compute.builder.BlockDeviceMappingBuilder;

public class NovaBlockDeviceMappingCreate
implements BlockDeviceMappingCreate {
    public String device_name;
    public BDMSourceType source_type = BDMSourceType.VOLUME;
    public BDMDestType destination_type = BDMDestType.VOLUME;
    public String uuid;
    public Integer boot_index;
    public Integer volume_size;
    public boolean delete_on_termination = false;
    @JsonProperty(value="snapshot_id")
    public String snapshotId;
    @JsonProperty(value="volume_id")
    public String volumeId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="disk_bus")
    public String diskBus;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="device_type")
    public String deviceType;
    @JsonProperty(value="volume_type")
    public BDMVolumeType volumeType;

    public static NovaBlockDeviceMappingBuilder builder() {
        return new NovaBlockDeviceMappingBuilder(new NovaBlockDeviceMappingCreate());
    }

    @Override
    public NovaBlockDeviceMappingBuilder toBuilder() {
        return new NovaBlockDeviceMappingBuilder(this);
    }

    public static class NovaBlockDeviceMappingBuilder
    implements BlockDeviceMappingBuilder {
        NovaBlockDeviceMappingCreate create;

        public NovaBlockDeviceMappingBuilder(NovaBlockDeviceMappingCreate create) {
            this.create = create;
        }

        @Override
        public BlockDeviceMappingBuilder deviceName(String deviceName) {
            this.create.device_name = deviceName;
            return this;
        }

        @Override
        public BlockDeviceMappingBuilder uuid(String id) {
            this.create.uuid = id;
            return this;
        }

        @Override
        public BlockDeviceMappingBuilder bootIndex(int i) {
            this.create.boot_index = i;
            return this;
        }

        @Override
        public BlockDeviceMappingBuilder sourceType(BDMSourceType type) {
            this.create.source_type = type;
            return this;
        }

        @Override
        public BlockDeviceMappingBuilder destinationType(BDMDestType type) {
            this.create.destination_type = type;
            return this;
        }

        @Override
        public BlockDeviceMappingBuilder deleteOnTermination(boolean deleteOnTermination) {
            this.create.delete_on_termination = deleteOnTermination;
            return this;
        }

        @Override
        public BlockDeviceMappingBuilder snapshotId(String snapshotId) {
            this.create.snapshotId = snapshotId;
            return this;
        }

        @Override
        public BlockDeviceMappingBuilder volumeId(String volumeId) {
            this.create.volumeId = volumeId;
            return this;
        }

        @Override
        public BlockDeviceMappingBuilder volumeSize(Integer volumeSize) {
            this.create.volume_size = volumeSize;
            return this;
        }

        @Override
        public BlockDeviceMappingBuilder diskBus(String diskBus) {
            this.create.diskBus = diskBus;
            return this;
        }

        @Override
        public BlockDeviceMappingBuilder deviceType(String deviceType) {
            this.create.deviceType = deviceType;
            return this;
        }

        @Override
        public BlockDeviceMappingBuilder volumeType(BDMVolumeType volumeType) {
            this.create.volumeType = volumeType;
            return this;
        }

        @Override
        public BlockDeviceMappingCreate build() {
            return this.create;
        }

        @Override
        public BlockDeviceMappingBuilder from(BlockDeviceMappingCreate in) {
            return new NovaBlockDeviceMappingBuilder((NovaBlockDeviceMappingCreate)in);
        }
    }
}

