/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.compute.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.base.MoreObjects;
import com.huawei.openstack4j.model.common.Link;
import com.huawei.openstack4j.model.compute.IPProtocol;
import com.huawei.openstack4j.model.compute.SecGroupExtension;
import com.huawei.openstack4j.model.compute.builder.SecurityGroupRuleBuilder;
import com.huawei.openstack4j.openstack.common.GenericLink;
import com.huawei.openstack4j.openstack.common.ListResult;
import java.util.List;

@JsonRootName(value="security_group")
public class NovaSecGroupExtension
implements SecGroupExtension {
    private static final long serialVersionUID = 1L;
    private String id;
    private String name;
    private String description;
    @JsonProperty(value="tenant_id")
    private String tenantId;
    private List<SecurityGroupRule> rules;
    private List<GenericLink> links;

    public static NovaSecGroupExtension create(String name, String description) {
        NovaSecGroupExtension sg = new NovaSecGroupExtension();
        sg.name = name;
        sg.description = description;
        return sg;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public List<? extends SecGroupExtension.Rule> getRules() {
        return this.rules;
    }

    @Override
    public List<? extends Link> getLinks() {
        return this.links;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("id", (Object)this.id).add("name", (Object)this.name).add("description", (Object)this.description).add("tenantId", (Object)this.tenantId).add("rules", this.rules).add("links", this.links).toString();
    }

    @JsonRootName(value="security_group_rule")
    public static class SecurityGroupRule
    implements SecGroupExtension.Rule {
        private static final long serialVersionUID = 1L;
        private String id;
        private String name;
        @JsonProperty(value="parent_group_id")
        private String parentGroupId;
        @JsonProperty(value="from_port")
        private Integer fromPort;
        @JsonProperty(value="to_port")
        private Integer toPort;
        @JsonProperty(value="ip_protocol")
        private IPProtocol ipProtocol;
        @JsonProperty(value="ip_range")
        private RuleIpRange ipRange;
        private RuleGroup group;
        @JsonProperty(value="cidr")
        String cidr;
        @JsonProperty(value="group_id")
        String groupId;

        @Override
        public IPProtocol getIPProtocol() {
            return this.ipProtocol != null ? this.ipProtocol : IPProtocol.UNRECOGNIZED;
        }

        @Override
        public SecGroupExtension.Rule.Group getGroup() {
            return this.group;
        }

        @Override
        public SecGroupExtension.Rule.IpRange getRange() {
            return this.ipRange;
        }

        @Override
        public int getToPort() {
            return this.toPort != null ? this.toPort : 0;
        }

        @Override
        public int getFromPort() {
            return this.fromPort != null ? this.fromPort : 0;
        }

        @Override
        public String getParentGroupId() {
            return this.parentGroupId;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getId() {
            return this.id;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"Rule").omitNullValues().add("id", (Object)this.id).add("name", (Object)this.name).add("parentGroupId", (Object)this.parentGroupId).add("fromPort", (Object)this.fromPort).add("toPort", (Object)this.toPort).add("ipProtocol", (Object)this.ipProtocol).add("range", (Object)this.ipRange).add("group", (Object)this.group).toString();
        }

        @Override
        public SecurityGroupRuleBuilder toBuilder() {
            return new RuleConcreteBuilder(this);
        }

        public static SecurityGroupRuleBuilder builder() {
            return new RuleConcreteBuilder();
        }

        public static class RuleIpRange
        implements SecGroupExtension.Rule.IpRange {
            private String cidr;

            @Override
            public String getCidr() {
                return this.cidr;
            }

            public String toString() {
                return MoreObjects.toStringHelper((Object)this).add("cidr", (Object)this.cidr).toString();
            }
        }

        public static class RuleGroup
        implements SecGroupExtension.Rule.Group {
            private String name;
            @JsonProperty(value="tenant_id")
            private String tenantId;

            @Override
            public String getName() {
                return this.name;
            }

            @Override
            public String getTenantId() {
                return this.tenantId;
            }

            public String toString() {
                return MoreObjects.toStringHelper((Object)this).omitNullValues().add("name", (Object)this.name).add("tenantId", (Object)this.tenantId).toString();
            }
        }

        public static class RuleConcreteBuilder
        implements SecurityGroupRuleBuilder {
            private SecurityGroupRule m;

            RuleConcreteBuilder() {
                this(new SecurityGroupRule());
            }

            RuleConcreteBuilder(SecurityGroupRule m) {
                this.m = m;
            }

            @Override
            public SecurityGroupRuleBuilder protocol(IPProtocol protocol) {
                this.m.ipProtocol = protocol;
                return this;
            }

            @Override
            public SecurityGroupRuleBuilder range(int fromPort, int toPort) {
                this.m.fromPort = fromPort;
                this.m.toPort = toPort;
                return this;
            }

            @Override
            public SecurityGroupRuleBuilder cidr(String cidr) {
                this.m.cidr = cidr;
                return this;
            }

            @Override
            public SecurityGroupRuleBuilder groupId(String groupId) {
                this.m.groupId = groupId;
                return this;
            }

            @Override
            public SecurityGroupRuleBuilder parentGroupId(String parentGroupId) {
                this.m.parentGroupId = parentGroupId;
                return this;
            }

            @Override
            public SecGroupExtension.Rule build() {
                return this.m;
            }

            @Override
            public SecurityGroupRuleBuilder from(SecGroupExtension.Rule in) {
                this.m = (SecurityGroupRule)in;
                return this;
            }
        }
    }

    public static class SecurityGroups
    extends ListResult<NovaSecGroupExtension> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="security_groups")
        private List<NovaSecGroupExtension> groups;

        @Override
        protected List<NovaSecGroupExtension> value() {
            return this.groups;
        }
    }
}

