/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.compute.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.databind.node.BinaryNode;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.huawei.openstack4j.model.compute.BlockDeviceMappingCreate;
import com.huawei.openstack4j.model.compute.Flavor;
import com.huawei.openstack4j.model.compute.Image;
import com.huawei.openstack4j.model.compute.NetworkCreate;
import com.huawei.openstack4j.model.compute.Personality;
import com.huawei.openstack4j.model.compute.SecurityGroup;
import com.huawei.openstack4j.model.compute.Server;
import com.huawei.openstack4j.model.compute.ServerCreate;
import com.huawei.openstack4j.model.compute.builder.ServerCreateBuilder;
import com.huawei.openstack4j.openstack.compute.domain.NovaNetworkCreate;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@JsonRootName(value="server")
public class NovaServerCreate
implements ServerCreate {
    private static final long serialVersionUID = 1L;
    private String name;
    private String adminPass;
    private String imageRef;
    private String flavorRef;
    private String accessIPv4;
    private String accessIPv6;
    @JsonProperty(value="min_count")
    private Integer min;
    @JsonProperty(value="max_count")
    private Integer max;
    private Server.DiskConfig diskConfig;
    @JsonProperty(value="metadata")
    private Map<String, String> metadata;
    @JsonProperty(value="user_data")
    private String userData;
    @JsonProperty(value="key_name")
    private String keyName;
    @JsonProperty(value="availability_zone")
    private String availabilityZone;
    @JsonProperty(value="config_drive")
    private Boolean configDrive;
    @JsonIgnore
    private transient Map<String, Object> schedulerHints;
    @JsonProperty(value="security_groups")
    private List<SecurityGroup> securityGroups;
    @JsonProperty(value="networks")
    private List<NovaNetworkCreate> networks;
    private List<Personality> personality;
    @JsonProperty(value="block_device_mapping_v2")
    private List<BlockDeviceMappingCreate> blockDeviceMapping;
    @JsonProperty(value="return_reservation_id")
    private boolean returnReservationId;

    public static ServerCreateBuilder builder() {
        return new ServerCreateConcreteBuilder();
    }

    @Override
    public ServerCreateBuilder toBuilder() {
        return new ServerCreateConcreteBuilder(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getAdminPass() {
        return this.adminPass;
    }

    @Override
    public String getImageRef() {
        return this.imageRef;
    }

    @Override
    public String getFlavorRef() {
        return this.flavorRef;
    }

    @Override
    public String getAccessIPv4() {
        return this.accessIPv4;
    }

    @Override
    public String getAccessIPv6() {
        return this.accessIPv6;
    }

    @Override
    public Integer getMin() {
        return this.min;
    }

    @Override
    public Integer getMax() {
        return this.max;
    }

    @Override
    public Server.DiskConfig getDiskConfig() {
        return this.diskConfig;
    }

    @Override
    public String getKeyName() {
        return this.keyName;
    }

    @Override
    public String getUserData() {
        return this.userData;
    }

    @Override
    @JsonIgnore
    public Map<String, String> getMetaData() {
        return this.metadata;
    }

    @Override
    public List<? extends SecurityGroup> getSecurityGroups() {
        return this.securityGroups;
    }

    @Override
    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    @Override
    @JsonIgnore
    public Map<String, Object> getSchedulerHints() {
        return this.schedulerHints;
    }

    @Override
    @JsonIgnore
    public boolean isConfigDrive() {
        return this.configDrive != null && this.configDrive != false;
    }

    @Override
    @JsonIgnore
    public List<? extends NetworkCreate> getNetworks() {
        return this.networks != null ? this.networks : Collections.emptyList();
    }

    @Override
    public List<Personality> getPersonality() {
        return this.personality;
    }

    @Override
    public void addPersonality(String path, String contents) {
        if (this.personality == null) {
            this.personality = Lists.newArrayList();
        }
        this.personality.add(new Personality(path, contents));
    }

    @Override
    public void addSecurityGroup(String name) {
        if (this.securityGroups == null) {
            this.securityGroups = Lists.newArrayList();
        }
        this.securityGroups.add(new SecurityGroupInternal(name));
    }

    @Override
    public void addNetwork(String id, String fixedIP) {
        this.initNetworks();
        this.networks.add(new NovaNetworkCreate(id, fixedIP));
    }

    @Override
    public void addNetworkPort(String id) {
        this.initNetworks();
        this.networks.add(new NovaNetworkCreate(null, null, id));
    }

    private void initNetworks() {
        if (this.networks == null) {
            this.networks = Lists.newArrayList();
        }
    }

    public boolean isReturnReservationId() {
        return this.returnReservationId;
    }

    public void setReturnReservationId(boolean returnReservationId) {
        this.returnReservationId = returnReservationId;
    }

    public static class ServerCreateConcreteBuilder
    implements ServerCreateBuilder {
        NovaServerCreate m;

        ServerCreateConcreteBuilder() {
            this(new NovaServerCreate());
        }

        ServerCreateConcreteBuilder(NovaServerCreate m) {
            this.m = m;
        }

        @Override
        public ServerCreateConcreteBuilder name(String name) {
            this.m.name = name;
            return this;
        }

        @Override
        public ServerCreateConcreteBuilder flavor(String flavorId) {
            this.m.flavorRef = flavorId;
            return this;
        }

        @Override
        public ServerCreateConcreteBuilder flavor(Flavor flavor) {
            this.m.flavorRef = flavor.getId();
            return this;
        }

        @Override
        public ServerCreateConcreteBuilder image(String imageId) {
            this.m.imageRef = imageId;
            return this;
        }

        @Override
        public ServerCreateConcreteBuilder image(Image image) {
            this.m.imageRef = image.getId();
            return this;
        }

        public ServerCreateConcreteBuilder zone(String availabilityZone) {
            this.m.availabilityZone = availabilityZone;
            return this;
        }

        @Override
        public ServerCreateConcreteBuilder networks(List<String> idList) {
            if (idList != null) {
                for (String id : idList) {
                    this.m.addNetwork(id, null);
                }
            }
            return this;
        }

        @Override
        public ServerCreateBuilder addNetworkPort(String portId) {
            this.m.addNetworkPort(portId);
            return this;
        }

        @Override
        public ServerCreateBuilder addSecurityGroup(String name) {
            if (name != null && !name.isEmpty()) {
                this.m.addSecurityGroup(name);
            }
            return this;
        }

        @Override
        public ServerCreateBuilder addPersonality(String path, String contents) {
            if (path == null || contents == null) {
                return this;
            }
            if (this.m.personality == null) {
                this.m.personality = Lists.newArrayList();
            }
            this.m.personality.add(new Personality(path, new BinaryNode(contents.getBytes()).asText()));
            return this;
        }

        @Override
        public ServerCreateBuilder keypairName(String name) {
            this.m.keyName = name;
            return this;
        }

        @Override
        public ServerCreateBuilder availabilityZone(String availabilityZone) {
            this.m.availabilityZone = availabilityZone;
            return this;
        }

        @Override
        public ServerCreate build() {
            return this.m;
        }

        @Override
        public ServerCreateConcreteBuilder from(ServerCreate in) {
            this.m = (NovaServerCreate)in;
            return this;
        }

        @Override
        public ServerCreateBuilder blockDevice(BlockDeviceMappingCreate blockDevice) {
            if (blockDevice != null && this.m.blockDeviceMapping == null) {
                this.m.blockDeviceMapping = Lists.newArrayList();
            }
            this.m.blockDeviceMapping.add(blockDevice);
            return this;
        }

        @Override
        public ServerCreateBuilder userData(String userData) {
            this.m.userData = userData;
            return this;
        }

        @Override
        public ServerCreateBuilder addMetadataItem(String key, String value) {
            if (this.m.metadata == null) {
                this.m.metadata = Maps.newHashMap();
            }
            this.m.metadata.put(key, value);
            return this;
        }

        @Override
        public ServerCreateBuilder addMetadata(Map<String, String> metadata) {
            this.m.metadata = metadata;
            return this;
        }

        @Override
        public ServerCreateBuilder addSchedulerHint(String key, String value) {
            return this.addSchedulerHintItem(key, value);
        }

        @Override
        public ServerCreateBuilder addSchedulerHint(String key, List<String> value) {
            return this.addSchedulerHintItem(key, value);
        }

        private ServerCreateBuilder addSchedulerHintItem(String key, Object value) {
            if (this.m.schedulerHints == null) {
                this.m.schedulerHints = Maps.newHashMap();
            }
            this.m.schedulerHints.put(key, value);
            return this;
        }

        @Override
        public ServerCreateBuilder addSchedulerHints(Map<String, Object> schedulerHints) {
            this.m.schedulerHints = schedulerHints;
            return this;
        }

        @Override
        public ServerCreateBuilder addAdminPass(String adminPass) {
            this.m.adminPass = adminPass;
            return this;
        }

        @Override
        public ServerCreateBuilder configDrive(boolean configDrive) {
            this.m.configDrive = configDrive;
            return this;
        }

        @Override
        public ServerCreateBuilder min(Integer min) {
            this.m.min = min;
            return this;
        }

        @Override
        public ServerCreateBuilder max(Integer max) {
            this.m.max = max;
            return this;
        }
    }

    static class SecurityGroupInternal
    implements SecurityGroup {
        private static final long serialVersionUID = 1L;
        private String name;

        SecurityGroupInternal() {
        }

        SecurityGroupInternal(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

