/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.compute.functions;

import com.google.common.base.Function;
import com.huawei.openstack4j.core.transport.HttpEntityHandler;
import com.huawei.openstack4j.core.transport.HttpResponse;
import com.huawei.openstack4j.core.transport.functions.ResponseToActionResponse;
import com.huawei.openstack4j.model.common.ActionResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToActionResponseFunction
implements Function<HttpResponse, ActionResponse> {
    public static final ToActionResponseFunction INSTANCE = new ToActionResponseFunction();
    private static final Logger LOG = LoggerFactory.getLogger(ToActionResponseFunction.class);
    private static final String FAILED_MSG = "Cannot '%s' while instance in in state of %s";

    public ActionResponse apply(HttpResponse response) {
        return this.apply(response, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionResponse apply(HttpResponse response, String action) {
        try {
            if (response.getStatus() == 409 || response.getStatus() == 500) {
                ActionResponse ar = ResponseToActionResponse.INSTANCE.apply(response, true);
                if (ar != null) {
                    ActionResponse actionResponse = ar;
                    return actionResponse;
                }
                LOG.error("{}, {}", (Object)response.getStatus(), (Object)response.getStatusMessage());
                if (action == null) {
                    ActionResponse actionResponse = ActionResponse.actionFailed("Instance currently is in build state", 409);
                    return actionResponse;
                }
                ActionResponse actionResponse = ActionResponse.actionFailed(String.format(FAILED_MSG, action, action), 409);
                return actionResponse;
            }
            if (response.getStatus() >= 400 && response.getStatus() < 409) {
                ActionResponse actionResponse = ResponseToActionResponse.INSTANCE.apply(response);
                return actionResponse;
            }
            ActionResponse actionResponse = ActionResponse.actionSuccess();
            return actionResponse;
        }
        finally {
            HttpEntityHandler.closeQuietly(response);
        }
    }
}

