/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.compute.internal;

import com.google.common.base.Preconditions;
import com.huawei.openstack4j.api.compute.QuotaSetService;
import com.huawei.openstack4j.model.compute.Limits;
import com.huawei.openstack4j.model.compute.QuotaSet;
import com.huawei.openstack4j.model.compute.QuotaSetUpdate;
import com.huawei.openstack4j.model.compute.SimpleTenantUsage;
import com.huawei.openstack4j.openstack.compute.domain.NovaLimits;
import com.huawei.openstack4j.openstack.compute.domain.NovaQuotaSet;
import com.huawei.openstack4j.openstack.compute.domain.NovaQuotaSetUpdate;
import com.huawei.openstack4j.openstack.compute.domain.NovaSimpleTenantUsage;
import com.huawei.openstack4j.openstack.compute.internal.BaseComputeServices;
import com.huawei.openstack4j.openstack.internal.BaseOpenStackService;
import java.util.List;

public class QuotaSetServiceImpl
extends BaseComputeServices
implements QuotaSetService {
    @Override
    public QuotaSet get(String tenantId) {
        return this.get(tenantId, null);
    }

    @Override
    public QuotaSet get(String tenantId, String userId) {
        Preconditions.checkNotNull((Object)tenantId);
        String uri = this.uri("/os-quota-sets/%s", tenantId);
        BaseOpenStackService.Invocation<NovaQuotaSet> req = null;
        req = userId != null ? this.get(NovaQuotaSet.class, uri).param("user_id", userId) : this.get(NovaQuotaSet.class, uri);
        return req.execute();
    }

    @Override
    public QuotaSet updateForClass(String classId, QuotaSetUpdate qs) {
        Preconditions.checkNotNull((Object)classId);
        Preconditions.checkNotNull((Object)qs);
        return this.put(NovaQuotaSet.NovaQuotaSetClass.class, this.uri("/os-quota-class-sets/%s", classId)).entity(NovaQuotaSetUpdate.NovaQuotaSetUpdateClass.from(qs)).execute();
    }

    @Override
    public QuotaSet updateForTenant(String tenantId, QuotaSetUpdate qs) {
        Preconditions.checkNotNull((Object)tenantId);
        Preconditions.checkNotNull((Object)qs);
        return this.put(NovaQuotaSet.class, this.uri("/os-quota-sets/%s", tenantId)).entity(NovaQuotaSetUpdate.NovaQuotaSetUpdateTenant.from(qs)).execute();
    }

    @Override
    public Limits limits() {
        return this.get(NovaLimits.class, this.uri("/limits", new Object[0])).execute();
    }

    @Override
    public List<? extends SimpleTenantUsage> listTenantUsages() {
        return this.get(NovaSimpleTenantUsage.NovaSimpleTenantUsages.class, this.uri("/os-simple-tenant-usage", new Object[0])).execute().getList();
    }

    @Override
    public SimpleTenantUsage getTenantUsage(String tenantId) {
        Preconditions.checkNotNull((Object)tenantId);
        return this.get(NovaSimpleTenantUsage.class, this.uri("/os-simple-tenant-usage/%s", tenantId)).execute();
    }

    @Override
    public List<? extends SimpleTenantUsage> listTenantUsages(String startTime, String endTime) {
        Preconditions.checkNotNull((Object)startTime);
        Preconditions.checkNotNull((Object)endTime);
        return this.get(NovaSimpleTenantUsage.NovaSimpleTenantUsages.class, this.uri("/os-simple-tenant-usage", new Object[0])).param("start", startTime).param("end", endTime).execute().getList();
    }

    @Override
    public SimpleTenantUsage getTenantUsage(String tenantId, String startTime, String endTime) {
        Preconditions.checkNotNull((Object)tenantId);
        Preconditions.checkNotNull((Object)startTime);
        Preconditions.checkNotNull((Object)endTime);
        return this.get(NovaSimpleTenantUsage.class, this.uri("/os-simple-tenant-usage/%s", tenantId)).param("start", startTime).param("end", endTime).param("detailed", "1").execute();
    }

    @Override
    public QuotaSet getDefault(String tenantId) {
        Preconditions.checkNotNull((Object)tenantId);
        return this.get(NovaQuotaSet.class, this.uri("/os-quota-sets/%s/defaults", tenantId)).execute();
    }
}

