/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.compute.internal;

import com.google.common.base.Preconditions;
import com.huawei.openstack4j.api.Apis;
import com.huawei.openstack4j.api.compute.ServerService;
import com.huawei.openstack4j.api.compute.ext.InstanceActionsService;
import com.huawei.openstack4j.api.compute.ext.InterfaceService;
import com.huawei.openstack4j.core.transport.ExecutionOptions;
import com.huawei.openstack4j.core.transport.HttpResponse;
import com.huawei.openstack4j.core.transport.propagation.PropagateOnStatus;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.model.compute.Action;
import com.huawei.openstack4j.model.compute.RebootType;
import com.huawei.openstack4j.model.compute.Server;
import com.huawei.openstack4j.model.compute.ServerCreate;
import com.huawei.openstack4j.model.compute.ServerPassword;
import com.huawei.openstack4j.model.compute.ServerUpdateOptions;
import com.huawei.openstack4j.model.compute.StopType;
import com.huawei.openstack4j.model.compute.VNCConsole;
import com.huawei.openstack4j.model.compute.VolumeAttachment;
import com.huawei.openstack4j.model.compute.actions.BackupOptions;
import com.huawei.openstack4j.model.compute.actions.EvacuateOptions;
import com.huawei.openstack4j.model.compute.actions.LiveMigrateOptions;
import com.huawei.openstack4j.model.compute.actions.RebuildOptions;
import com.huawei.openstack4j.model.compute.builder.ServerCreateBuilder;
import com.huawei.openstack4j.openstack.common.Metadata;
import com.huawei.openstack4j.openstack.compute.domain.AdminPass;
import com.huawei.openstack4j.openstack.compute.domain.ConsoleOutput;
import com.huawei.openstack4j.openstack.compute.domain.ConsoleOutputOptions;
import com.huawei.openstack4j.openstack.compute.domain.MetadataItem;
import com.huawei.openstack4j.openstack.compute.domain.NovaPassword;
import com.huawei.openstack4j.openstack.compute.domain.NovaServer;
import com.huawei.openstack4j.openstack.compute.domain.NovaServerCreate;
import com.huawei.openstack4j.openstack.compute.domain.NovaServerUpdate;
import com.huawei.openstack4j.openstack.compute.domain.NovaVNCConsole;
import com.huawei.openstack4j.openstack.compute.domain.NovaVolumeAttachment;
import com.huawei.openstack4j.openstack.compute.domain.actions.BackupAction;
import com.huawei.openstack4j.openstack.compute.domain.actions.BasicActions;
import com.huawei.openstack4j.openstack.compute.domain.actions.CreateSnapshotAction;
import com.huawei.openstack4j.openstack.compute.domain.actions.EvacuateAction;
import com.huawei.openstack4j.openstack.compute.domain.actions.LiveMigrationAction;
import com.huawei.openstack4j.openstack.compute.domain.actions.RebuildAction;
import com.huawei.openstack4j.openstack.compute.domain.actions.ResetStateAction;
import com.huawei.openstack4j.openstack.compute.domain.actions.SecurityGroupActions;
import com.huawei.openstack4j.openstack.compute.domain.actions.ServerAction;
import com.huawei.openstack4j.openstack.compute.functions.ToActionResponseFunction;
import com.huawei.openstack4j.openstack.compute.functions.WrapServerIfApplicableFunction;
import com.huawei.openstack4j.openstack.compute.internal.BaseComputeServices;
import com.huawei.openstack4j.openstack.internal.BaseOpenStackService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerServiceImpl
extends BaseComputeServices
implements ServerService {
    private static final Logger LOG = LoggerFactory.getLogger(ServerServiceImpl.class);

    @Override
    public List<? extends Server> list() {
        return this.list(true);
    }

    @Override
    public List<? extends Server> list(boolean detail) {
        return this.list(detail, Boolean.FALSE);
    }

    @Override
    public List<? extends Server> list(boolean detail, Map<String, String> filteringParams) {
        return this.list(detail, Boolean.FALSE, filteringParams);
    }

    private List<? extends Server> list(boolean detail, boolean allTenants) {
        BaseOpenStackService.Invocation<NovaServer.Servers> req = this.get(NovaServer.Servers.class, this.uri("/servers" + (detail ? "/detail" : ""), new Object[0]));
        if (allTenants) {
            req.param("all_tenants", 1);
        }
        return req.execute().getList();
    }

    private List<? extends Server> list(boolean detail, boolean allTenants, Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<NovaServer.Servers> req = this.get(NovaServer.Servers.class, this.uri("/servers" + (detail ? "/detail" : ""), new Object[0]));
        if (allTenants) {
            req.param("all_tenants", 1);
        }
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                req = req.param(entry.getKey(), entry.getValue());
            }
        }
        return req.execute().getList();
    }

    @Override
    public List<? extends Server> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<NovaServer.Servers> serverInvocation = this.get(NovaServer.Servers.class, "/servers/detail");
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                serverInvocation = serverInvocation.param(entry.getKey(), entry.getValue());
            }
        }
        return serverInvocation.execute().getList();
    }

    @Override
    public Server get(String serverId) {
        Preconditions.checkNotNull((Object)serverId);
        return this.get(NovaServer.class, this.uri("/servers/%s", serverId)).execute();
    }

    @Override
    public Server boot(ServerCreate server) {
        Preconditions.checkNotNull((Object)server);
        NovaServerCreate create = (NovaServerCreate)server;
        create.setReturnReservationId(false);
        return this.post(NovaServer.class, this.uri("/servers", new Object[0])).entity(WrapServerIfApplicableFunction.INSTANCE.apply(create)).execute();
    }

    @Override
    public Server bootAndWaitActive(ServerCreate server, int maxWaitTime) {
        return this.waitForServerStatus(this.boot(server).getId(), Server.Status.ACTIVE, maxWaitTime, TimeUnit.MILLISECONDS);
    }

    @Override
    public ActionResponse delete(String serverId) {
        Preconditions.checkNotNull((Object)serverId);
        return ToActionResponseFunction.INSTANCE.apply(this.delete(Void.class, this.uri("/servers/%s", serverId)).executeWithResponse());
    }

    @Override
    public ActionResponse action(String serverId, Action action) {
        Preconditions.checkNotNull((Object)serverId);
        ServerAction instance = BasicActions.actionInstanceFor(action);
        if (instance == null) {
            return ActionResponse.actionFailed(String.format("Action %s was not found in the list of invokable actions", new Object[]{action}), 412);
        }
        return this.invokeAction(serverId, instance);
    }

    @Override
    public String createSnapshot(String serverId, String snapshotName) {
        String location;
        Preconditions.checkNotNull((Object)serverId);
        Preconditions.checkNotNull((Object)snapshotName);
        HttpResponse response = this.invokeActionWithResponse(serverId, CreateSnapshotAction.create(snapshotName));
        String id = null;
        if (response.getStatus() == 202 && (location = response.header("location")) != null && location.contains("/")) {
            String[] s = location.split("/");
            id = s[s.length - 1];
        }
        response.getEntity(Void.class);
        return id;
    }

    @Override
    public ActionResponse stop(String serverId, StopType type) {
        Preconditions.checkNotNull((Object)serverId);
        return this.invokeAction(serverId, new BasicActions.StopWithType(type));
    }

    @Override
    public ActionResponse reboot(String serverId, RebootType type) {
        Preconditions.checkNotNull((Object)serverId);
        return this.invokeAction(serverId, new BasicActions.Reboot(type));
    }

    @Override
    public ActionResponse rebuild(String serverId, RebuildOptions options) {
        Preconditions.checkNotNull((Object)serverId);
        return this.invokeAction(serverId, RebuildAction.create(options));
    }

    @Override
    public ActionResponse resize(String serverId, String flavorId) {
        Preconditions.checkNotNull((Object)serverId);
        Preconditions.checkNotNull((Object)flavorId);
        return this.invokeAction(serverId, new BasicActions.Resize(flavorId));
    }

    @Override
    public ActionResponse addSecurityGroup(String serverId, String secGroupName) {
        Preconditions.checkNotNull((Object)serverId);
        Preconditions.checkNotNull((Object)secGroupName);
        return this.invokeAction(serverId, SecurityGroupActions.add(secGroupName));
    }

    @Override
    public ActionResponse removeSecurityGroup(String serverId, String secGroupName) {
        Preconditions.checkNotNull((Object)serverId);
        Preconditions.checkNotNull((Object)secGroupName);
        return this.invokeAction(serverId, SecurityGroupActions.remove(secGroupName));
    }

    @Override
    public ActionResponse confirmResize(String serverId) {
        Preconditions.checkNotNull((Object)serverId);
        return this.invokeAction(serverId, BasicActions.instanceFor(BasicActions.ConfirmResize.class));
    }

    @Override
    public ActionResponse revertResize(String serverId) {
        Preconditions.checkNotNull((Object)serverId);
        return this.invokeAction(serverId, BasicActions.instanceFor(BasicActions.RevertResize.class));
    }

    @Override
    public String getConsoleOutput(String serverId, int numLines) {
        Preconditions.checkNotNull((Object)serverId);
        ConsoleOutputOptions consoleOutputOptions = new ConsoleOutputOptions(numLines);
        ConsoleOutput c = this.post(ConsoleOutput.class, this.uri("/servers/%s/action", serverId)).entity(consoleOutputOptions).execute();
        return c != null ? c.getOutput() : null;
    }

    @Override
    public VNCConsole getVNCConsole(String serverId, VNCConsole.Type type) {
        Preconditions.checkNotNull((Object)serverId);
        if (type == null) {
            type = VNCConsole.Type.NOVNC;
        }
        return this.post(NovaVNCConsole.class, this.uri("/servers/%s/action", serverId)).entity(NovaVNCConsole.getConsoleForType(type)).execute();
    }

    @Override
    public Map<String, ? extends Number> diagnostics(String serverId) {
        return this.get(HashMap.class, this.uri("/servers/%s/diagnostics", serverId)).execute();
    }

    @Override
    public ServerCreateBuilder serverBuilder() {
        return NovaServerCreate.builder();
    }

    @Override
    public VolumeAttachment attachVolume(String serverId, String volumeId, String device) {
        Preconditions.checkNotNull((Object)serverId);
        Preconditions.checkNotNull((Object)volumeId);
        Preconditions.checkNotNull((Object)device);
        return this.post(NovaVolumeAttachment.class, this.uri("/servers/%s/os-volume_attachments", serverId)).entity(NovaVolumeAttachment.create(volumeId, device)).execute(ExecutionOptions.create(PropagateOnStatus.on(404)));
    }

    @Override
    public ActionResponse detachVolume(String serverId, String attachmentId) {
        Preconditions.checkNotNull((Object)serverId);
        Preconditions.checkNotNull((Object)attachmentId);
        return ToActionResponseFunction.INSTANCE.apply(this.delete(Void.class, this.uri("/servers/%s/os-volume_attachments/%s", serverId, attachmentId)).executeWithResponse());
    }

    @Override
    public ActionResponse detachVolume(String serverId, String volumeId, int deleteFlag) {
        Preconditions.checkNotNull((Object)serverId);
        Preconditions.checkNotNull((Object)volumeId);
        return ToActionResponseFunction.INSTANCE.apply(this.delete(Void.class, this.uri("/servers/%s/os-volume_attachments/%s", serverId, volumeId)).param("delete_flag", deleteFlag).executeWithResponse());
    }

    @Override
    public ActionResponse migrateServer(String serverId) {
        Preconditions.checkNotNull((Object)serverId);
        return this.invokeAction(serverId, BasicActions.instanceFor(BasicActions.Migrate.class));
    }

    @Override
    public ActionResponse liveMigrate(String serverId, LiveMigrateOptions options) {
        Preconditions.checkNotNull((Object)serverId);
        if (options == null) {
            options = LiveMigrateOptions.create();
        }
        return this.invokeAction(serverId, LiveMigrationAction.create(options));
    }

    @Override
    public ActionResponse resetState(String serverId, Server.Status state) {
        Preconditions.checkNotNull((Object)serverId);
        Preconditions.checkNotNull((Object)((Object)state));
        return this.invokeAction(serverId, ResetStateAction.create(state));
    }

    @Override
    public ActionResponse backupServer(String serverId, BackupOptions options) {
        Preconditions.checkNotNull((Object)serverId);
        Preconditions.checkNotNull((Object)options);
        return this.invokeAction(serverId, BackupAction.create(options));
    }

    @Override
    public Server waitForServerStatus(String serverId, Server.Status status, int maxWait, TimeUnit maxWaitUnit) {
        Preconditions.checkNotNull((Object)serverId);
        Server server = null;
        long maxTime = maxWaitUnit.toMillis(maxWait);
        for (long duration = 0L; duration < maxTime && (server = this.get(serverId)) != null && server.getStatus() != status && server.getStatus() != Server.Status.ERROR; duration += (long)this.sleep(1000)) {
        }
        return server;
    }

    @Override
    public Map<String, String> getMetadata(String serverId) {
        Preconditions.checkNotNull((Object)serverId);
        return this.get(Metadata.class, this.uri("/servers/%s/metadata", serverId)).execute();
    }

    @Override
    public Map<String, String> updateMetadata(String serverId, Map<String, String> metadata) {
        Preconditions.checkNotNull((Object)serverId);
        Preconditions.checkNotNull(metadata);
        return this.put(Metadata.class, this.uri("/servers/%s/metadata", serverId)).entity(Metadata.toMetadata(metadata)).execute();
    }

    @Override
    public Map<String, String> getMetadataItem(String serverId, String key) {
        Preconditions.checkNotNull((Object)serverId);
        Preconditions.checkNotNull((Object)key);
        return this.get(MetadataItem.class, this.uri("/servers/%s/metadata/%s", serverId, key)).execute();
    }

    @Override
    public Map<String, String> setMetadataItem(String serverId, String key, String value) {
        Preconditions.checkNotNull((Object)serverId);
        Preconditions.checkNotNull((Object)value);
        Preconditions.checkNotNull((Object)key);
        HashMap<String, String> metadataMap = new HashMap<String, String>();
        metadataMap.put(key, value);
        return this.put(MetadataItem.class, this.uri("/servers/%s/metadata/%s", serverId, key)).entity(MetadataItem.toMetadataItem(metadataMap)).execute();
    }

    @Override
    public ActionResponse deleteMetadataItem(String serverId, String key) {
        Preconditions.checkNotNull((Object)serverId);
        Preconditions.checkNotNull((Object)key);
        return ToActionResponseFunction.INSTANCE.apply(this.delete(Void.class, this.uri("/servers/%s/metadata/%s", serverId, key)).executeWithResponse());
    }

    private int sleep(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        return ms;
    }

    @Override
    public Server update(String serverId, ServerUpdateOptions options) {
        Preconditions.checkNotNull((Object)serverId);
        Preconditions.checkNotNull((Object)options);
        return this.put(NovaServer.class, this.uri("/servers/%s", serverId)).entity(NovaServerUpdate.fromOptions(options)).execute();
    }

    @Override
    public InterfaceService interfaces() {
        return Apis.get(InterfaceService.class);
    }

    @Override
    public InstanceActionsService instanceActions() {
        return Apis.get(InstanceActionsService.class);
    }

    @Override
    public ServerPassword getPassword(String serverId) {
        Preconditions.checkNotNull((Object)serverId);
        return this.get(NovaPassword.class, this.uri("/servers/%s/os-server-password", serverId)).execute();
    }

    @Override
    public ServerPassword evacuate(String serverId, EvacuateOptions options) {
        Preconditions.checkNotNull((Object)serverId);
        return this.post(AdminPass.class, this.uri("/servers/%s/action", serverId)).entity(EvacuateAction.create(options)).execute();
    }

    @Override
    public VolumeAttachment getAttachVolume(String serverId, String volumeId) {
        Preconditions.checkNotNull((Object)serverId);
        Preconditions.checkNotNull((Object)volumeId);
        return this.get(NovaVolumeAttachment.class, this.uri("/servers/%s/os-volume_attachments/%s", serverId, volumeId)).execute();
    }

    @Override
    public List<? extends VolumeAttachment> listAttachedVolumes(String serverId) {
        Preconditions.checkNotNull((Object)serverId);
        BaseOpenStackService.Invocation<NovaVolumeAttachment.NovaVolumeAttachments> volumeAttachmentInvocation = this.get(NovaVolumeAttachment.NovaVolumeAttachments.class, this.uri("/servers/%s/os-volume_attachments", serverId));
        return volumeAttachmentInvocation.execute().getList();
    }
}

