/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.compute.internal.ext;

import com.google.common.base.Preconditions;
import com.huawei.openstack4j.api.compute.ext.InterfaceService;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.model.compute.InterfaceAttachment;
import com.huawei.openstack4j.openstack.compute.domain.NovaInterfaceAttachment;
import com.huawei.openstack4j.openstack.compute.domain.NovaInterfaceAttachmentCreate;
import com.huawei.openstack4j.openstack.compute.internal.BaseComputeServices;
import java.util.List;

public class InterfaceServiceImpl
extends BaseComputeServices
implements InterfaceService {
    @Override
    public InterfaceAttachment create(String serverId, String portId) {
        Preconditions.checkNotNull((Object)serverId, (Object)"serverId");
        Preconditions.checkNotNull((Object)portId, (Object)"portId");
        return this.post(NovaInterfaceAttachment.class, this.uri("/servers/%s/os-interface", serverId)).entity(new NovaInterfaceAttachment(portId)).execute();
    }

    @Override
    public InterfaceAttachment create(String serverId, NovaInterfaceAttachmentCreate interfaceAttachmentCreate) {
        Preconditions.checkNotNull((Object)serverId, (Object)"serverId");
        return this.post(NovaInterfaceAttachment.class, this.uri("/servers/%s/os-interface", serverId)).entity(interfaceAttachmentCreate).execute();
    }

    @Override
    public List<? extends InterfaceAttachment> list(String serverId) {
        Preconditions.checkNotNull((Object)serverId, (Object)"serverId");
        return this.get(NovaInterfaceAttachment.NovaInterfaceAttachments.class, this.uri("/servers/%s/os-interface", serverId)).execute().getList();
    }

    @Override
    public InterfaceAttachment get(String serverId, String attachmentId) {
        Preconditions.checkNotNull((Object)serverId, (Object)"serverId");
        Preconditions.checkNotNull((Object)attachmentId, (Object)"attachmentId");
        return this.get(NovaInterfaceAttachment.class, this.uri("/servers/%s/os-interface/%s", serverId, attachmentId)).execute();
    }

    @Override
    public ActionResponse detach(String serverId, String attachmentId) {
        Preconditions.checkNotNull((Object)serverId, (Object)"serverId");
        Preconditions.checkNotNull((Object)attachmentId, (Object)"attachmentId");
        return this.delete(ActionResponse.class, this.uri("/servers/%s/os-interface/%s", serverId, attachmentId)).execute();
    }
}

