/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.csbs.v1.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.openstack.compute.functions.ToActionResponseFunction;
import com.huawei.openstack4j.openstack.csbs.v1.domain.Policy;
import com.huawei.openstack4j.openstack.csbs.v1.domain.PolicyCreate;
import com.huawei.openstack4j.openstack.csbs.v1.domain.PolicyUpdate;
import com.huawei.openstack4j.openstack.csbs.v1.internal.BaseCloudServerBackupService;
import com.huawei.openstack4j.openstack.internal.BaseOpenStackService;
import java.util.List;
import java.util.Map;

public class BackupPoliciesService
extends BaseCloudServerBackupService {
    public Policy create(PolicyCreate policyCreate) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)policyCreate.getName()) ? 1 : 0) != 0, (Object)"parameter `name` should not be empty");
        Preconditions.checkArgument((policyCreate.getParameters() != null ? 1 : 0) != 0, (Object)"parameter `parameters` should not be empty");
        Preconditions.checkArgument((policyCreate.getResources() != null && policyCreate.getResources().size() > 0 ? 1 : 0) != 0, (Object)"parameter `resources` should not be empty");
        Preconditions.checkArgument((policyCreate.getScheduledOperations() != null && policyCreate.getScheduledOperations().size() > 0 ? 1 : 0) != 0, (Object)"parameter `scheduled_operations` should not be empty");
        return this.post(Policy.class, this.uri("/policies", new Object[0])).entity(policyCreate).execute();
    }

    public List<Policy> list() {
        return this.get(Policy.Policies.class, this.uri("/policies", new Object[0])).execute().getList();
    }

    public List<Policy> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<Policy.Policies> policyInvocation = this.get(Policy.Policies.class, "/policies");
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                policyInvocation = policyInvocation.param(entry.getKey(), entry.getValue());
            }
        }
        return policyInvocation.execute().getList();
    }

    public Policy get(String policyId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)policyId) ? 1 : 0) != 0, (Object)"parameter `policyId` should not be empty");
        return this.get(Policy.class, this.uri("/policies/%s", policyId)).execute();
    }

    public Policy update(String policyId, PolicyUpdate policyUpdate) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)policyId) ? 1 : 0) != 0, (Object)"parameter `policyId` should not be empty");
        Preconditions.checkArgument((policyUpdate != null ? 1 : 0) != 0, (Object)"parameter `policyUpdate` should not be empty");
        return this.put(Policy.class, this.uri("/policies/%s", policyId)).entity(policyUpdate).execute();
    }

    public ActionResponse delete(String policyId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)policyId) ? 1 : 0) != 0, (Object)"parameter `policyId` should not be empty");
        return ToActionResponseFunction.INSTANCE.apply(this.delete(Void.class, this.uri("/policies/%s", policyId)).executeWithResponse());
    }
}

