/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.database.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.huawei.openstack4j.model.ModelEntity;
import com.huawei.openstack4j.openstack.common.ListResult;
import com.huawei.openstack4j.openstack.database.constants.BackupStatus;
import com.huawei.openstack4j.openstack.database.domain.Datastore;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.List;

@JsonRootName(value="backup")
public class DatabaseBackup
implements ModelEntity {
    private static final long serialVersionUID = 5294355671374520846L;
    String id;
    String name;
    String description;
    String locationRef;
    Double size;
    BackupStatus status;
    @JsonProperty(value="backuptype")
    String backupType;
    @JsonProperty(value="dataStore")
    Datastore datastore;
    @JsonProperty(value="instance_id")
    String instanceId;
    @JsonProperty(value="parent_id")
    String parentId;
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss")
    Date created;
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss")
    Date updated;

    public static DatabaseBackupBuilder builder() {
        return new DatabaseBackupBuilder();
    }

    public DatabaseBackupBuilder toBuilder() {
        return new DatabaseBackupBuilder().id(this.id).name(this.name).description(this.description).locationRef(this.locationRef).size(this.size).status(this.status).backupType(this.backupType).datastore(this.datastore).instanceId(this.instanceId).parentId(this.parentId).created(this.created).updated(this.updated);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getLocationRef() {
        return this.locationRef;
    }

    public Double getSize() {
        return this.size;
    }

    public BackupStatus getStatus() {
        return this.status;
    }

    public String getBackupType() {
        return this.backupType;
    }

    public Datastore getDatastore() {
        return this.datastore;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getParentId() {
        return this.parentId;
    }

    public Date getCreated() {
        return this.created;
    }

    public Date getUpdated() {
        return this.updated;
    }

    public String toString() {
        return "DatabaseBackup(id=" + this.getId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", locationRef=" + this.getLocationRef() + ", size=" + this.getSize() + ", status=" + (Object)((Object)this.getStatus()) + ", backupType=" + this.getBackupType() + ", datastore=" + this.getDatastore() + ", instanceId=" + this.getInstanceId() + ", parentId=" + this.getParentId() + ", created=" + this.getCreated() + ", updated=" + this.getUpdated() + ")";
    }

    public DatabaseBackup() {
    }

    @ConstructorProperties(value={"id", "name", "description", "locationRef", "size", "status", "backupType", "datastore", "instanceId", "parentId", "created", "updated"})
    public DatabaseBackup(String id, String name, String description, String locationRef, Double size, BackupStatus status, String backupType, Datastore datastore, String instanceId, String parentId, Date created, Date updated) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.locationRef = locationRef;
        this.size = size;
        this.status = status;
        this.backupType = backupType;
        this.datastore = datastore;
        this.instanceId = instanceId;
        this.parentId = parentId;
        this.created = created;
        this.updated = updated;
    }

    public static class DatabaseBackupBuilder {
        private String id;
        private String name;
        private String description;
        private String locationRef;
        private Double size;
        private BackupStatus status;
        private String backupType;
        private Datastore datastore;
        private String instanceId;
        private String parentId;
        private Date created;
        private Date updated;

        DatabaseBackupBuilder() {
        }

        public DatabaseBackupBuilder id(String id) {
            this.id = id;
            return this;
        }

        public DatabaseBackupBuilder name(String name) {
            this.name = name;
            return this;
        }

        public DatabaseBackupBuilder description(String description) {
            this.description = description;
            return this;
        }

        public DatabaseBackupBuilder locationRef(String locationRef) {
            this.locationRef = locationRef;
            return this;
        }

        public DatabaseBackupBuilder size(Double size) {
            this.size = size;
            return this;
        }

        public DatabaseBackupBuilder status(BackupStatus status) {
            this.status = status;
            return this;
        }

        public DatabaseBackupBuilder backupType(String backupType) {
            this.backupType = backupType;
            return this;
        }

        public DatabaseBackupBuilder datastore(Datastore datastore) {
            this.datastore = datastore;
            return this;
        }

        public DatabaseBackupBuilder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public DatabaseBackupBuilder parentId(String parentId) {
            this.parentId = parentId;
            return this;
        }

        public DatabaseBackupBuilder created(Date created) {
            this.created = created;
            return this;
        }

        public DatabaseBackupBuilder updated(Date updated) {
            this.updated = updated;
            return this;
        }

        public DatabaseBackup build() {
            return new DatabaseBackup(this.id, this.name, this.description, this.locationRef, this.size, this.status, this.backupType, this.datastore, this.instanceId, this.parentId, this.created, this.updated);
        }

        public String toString() {
            return "DatabaseBackup.DatabaseBackupBuilder(id=" + this.id + ", name=" + this.name + ", description=" + this.description + ", locationRef=" + this.locationRef + ", size=" + this.size + ", status=" + (Object)((Object)this.status) + ", backupType=" + this.backupType + ", datastore=" + this.datastore + ", instanceId=" + this.instanceId + ", parentId=" + this.parentId + ", created=" + this.created + ", updated=" + this.updated + ")";
        }
    }

    public static class Backups
    extends ListResult<DatabaseBackup> {
        private static final long serialVersionUID = 7666104777418585874L;
        @JsonProperty(value="backups")
        List<DatabaseBackup> backups;

        @Override
        protected List<DatabaseBackup> value() {
            return this.backups;
        }
    }
}

