/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.database.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.huawei.openstack4j.model.ModelEntity;
import com.huawei.openstack4j.openstack.common.IdResourceEntity;
import com.huawei.openstack4j.openstack.common.ListResult;
import com.huawei.openstack4j.openstack.database.constants.InstanceType;
import com.huawei.openstack4j.openstack.database.domain.BackupStrategy;
import com.huawei.openstack4j.openstack.database.domain.Datastore;
import com.huawei.openstack4j.openstack.database.domain.HA;
import com.huawei.openstack4j.openstack.database.domain.NIC;
import com.huawei.openstack4j.openstack.database.domain.Volume;
import com.huawei.openstack4j.openstack.trove.domain.ExtendParam;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.List;

@JsonRootName(value="instance")
public class DatabaseInstance
implements ModelEntity {
    static final long serialVersionUID = -7399474725379713926L;
    String id;
    String name;
    String status;
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ssZ")
    Date created;
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ssZ")
    Date updated;
    String hostname;
    InstanceType type;
    String region;
    String availabilityZone;
    @JsonProperty(value="vpc")
    String vpcId;
    @JsonProperty(value="nics")
    NIC nic;
    IdResourceEntity securityGroup;
    @JsonProperty(value="flavor")
    IdResourceEntity flavor;
    List<String> ip;
    @JsonProperty(value="volume")
    Volume volume;
    @JsonProperty(value="dataStoreInfo")
    Datastore datastore;
    @JsonProperty(value="backupStrategy")
    BackupStrategy backupStrategy;
    @JsonProperty(value="ha")
    HA ha;
    @JsonProperty(value="slaveId")
    String slaveId;
    @JsonProperty(value="replica_of")
    String replicaOf;
    @JsonProperty(value="extendparam")
    ExtendParam extendParam;

    public static DatabaseInstanceBuilder builder() {
        return new DatabaseInstanceBuilder();
    }

    public DatabaseInstanceBuilder toBuilder() {
        return new DatabaseInstanceBuilder().id(this.id).name(this.name).status(this.status).created(this.created).updated(this.updated).hostname(this.hostname).type(this.type).region(this.region).availabilityZone(this.availabilityZone).vpcId(this.vpcId).nic(this.nic).securityGroup(this.securityGroup).flavor(this.flavor).ip(this.ip).volume(this.volume).datastore(this.datastore).backupStrategy(this.backupStrategy).ha(this.ha).slaveId(this.slaveId).replicaOf(this.replicaOf).extendParam(this.extendParam);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getStatus() {
        return this.status;
    }

    public Date getCreated() {
        return this.created;
    }

    public Date getUpdated() {
        return this.updated;
    }

    public String getHostname() {
        return this.hostname;
    }

    public InstanceType getType() {
        return this.type;
    }

    public String getRegion() {
        return this.region;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public String getVpcId() {
        return this.vpcId;
    }

    public NIC getNic() {
        return this.nic;
    }

    public IdResourceEntity getSecurityGroup() {
        return this.securityGroup;
    }

    public IdResourceEntity getFlavor() {
        return this.flavor;
    }

    public List<String> getIp() {
        return this.ip;
    }

    public Volume getVolume() {
        return this.volume;
    }

    public Datastore getDatastore() {
        return this.datastore;
    }

    public BackupStrategy getBackupStrategy() {
        return this.backupStrategy;
    }

    public HA getHa() {
        return this.ha;
    }

    public String getSlaveId() {
        return this.slaveId;
    }

    public String getReplicaOf() {
        return this.replicaOf;
    }

    public ExtendParam getExtendParam() {
        return this.extendParam;
    }

    public String toString() {
        return "DatabaseInstance(id=" + this.getId() + ", name=" + this.getName() + ", status=" + this.getStatus() + ", created=" + this.getCreated() + ", updated=" + this.getUpdated() + ", hostname=" + this.getHostname() + ", type=" + (Object)((Object)this.getType()) + ", region=" + this.getRegion() + ", availabilityZone=" + this.getAvailabilityZone() + ", vpcId=" + this.getVpcId() + ", nic=" + this.getNic() + ", securityGroup=" + this.getSecurityGroup() + ", flavor=" + this.getFlavor() + ", ip=" + this.getIp() + ", volume=" + this.getVolume() + ", datastore=" + this.getDatastore() + ", backupStrategy=" + this.getBackupStrategy() + ", ha=" + this.getHa() + ", slaveId=" + this.getSlaveId() + ", replicaOf=" + this.getReplicaOf() + ", extendParam=" + this.getExtendParam() + ")";
    }

    public DatabaseInstance() {
    }

    @ConstructorProperties(value={"id", "name", "status", "created", "updated", "hostname", "type", "region", "availabilityZone", "vpcId", "nic", "securityGroup", "flavor", "ip", "volume", "datastore", "backupStrategy", "ha", "slaveId", "replicaOf", "extendParam"})
    public DatabaseInstance(String id, String name, String status, Date created, Date updated, String hostname, InstanceType type, String region, String availabilityZone, String vpcId, NIC nic, IdResourceEntity securityGroup, IdResourceEntity flavor, List<String> ip, Volume volume, Datastore datastore, BackupStrategy backupStrategy, HA ha, String slaveId, String replicaOf, ExtendParam extendParam) {
        this.id = id;
        this.name = name;
        this.status = status;
        this.created = created;
        this.updated = updated;
        this.hostname = hostname;
        this.type = type;
        this.region = region;
        this.availabilityZone = availabilityZone;
        this.vpcId = vpcId;
        this.nic = nic;
        this.securityGroup = securityGroup;
        this.flavor = flavor;
        this.ip = ip;
        this.volume = volume;
        this.datastore = datastore;
        this.backupStrategy = backupStrategy;
        this.ha = ha;
        this.slaveId = slaveId;
        this.replicaOf = replicaOf;
        this.extendParam = extendParam;
    }

    public static class DatabaseInstanceBuilder {
        private String id;
        private String name;
        private String status;
        private Date created;
        private Date updated;
        private String hostname;
        private InstanceType type;
        private String region;
        private String availabilityZone;
        private String vpcId;
        private NIC nic;
        private IdResourceEntity securityGroup;
        private IdResourceEntity flavor;
        private List<String> ip;
        private Volume volume;
        private Datastore datastore;
        private BackupStrategy backupStrategy;
        private HA ha;
        private String slaveId;
        private String replicaOf;
        private ExtendParam extendParam;

        DatabaseInstanceBuilder() {
        }

        public DatabaseInstanceBuilder id(String id) {
            this.id = id;
            return this;
        }

        public DatabaseInstanceBuilder name(String name) {
            this.name = name;
            return this;
        }

        public DatabaseInstanceBuilder status(String status) {
            this.status = status;
            return this;
        }

        public DatabaseInstanceBuilder created(Date created) {
            this.created = created;
            return this;
        }

        public DatabaseInstanceBuilder updated(Date updated) {
            this.updated = updated;
            return this;
        }

        public DatabaseInstanceBuilder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public DatabaseInstanceBuilder type(InstanceType type) {
            this.type = type;
            return this;
        }

        public DatabaseInstanceBuilder region(String region) {
            this.region = region;
            return this;
        }

        public DatabaseInstanceBuilder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public DatabaseInstanceBuilder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public DatabaseInstanceBuilder nic(NIC nic) {
            this.nic = nic;
            return this;
        }

        public DatabaseInstanceBuilder securityGroup(IdResourceEntity securityGroup) {
            this.securityGroup = securityGroup;
            return this;
        }

        public DatabaseInstanceBuilder flavor(IdResourceEntity flavor) {
            this.flavor = flavor;
            return this;
        }

        public DatabaseInstanceBuilder ip(List<String> ip) {
            this.ip = ip;
            return this;
        }

        public DatabaseInstanceBuilder volume(Volume volume) {
            this.volume = volume;
            return this;
        }

        public DatabaseInstanceBuilder datastore(Datastore datastore) {
            this.datastore = datastore;
            return this;
        }

        public DatabaseInstanceBuilder backupStrategy(BackupStrategy backupStrategy) {
            this.backupStrategy = backupStrategy;
            return this;
        }

        public DatabaseInstanceBuilder ha(HA ha) {
            this.ha = ha;
            return this;
        }

        public DatabaseInstanceBuilder slaveId(String slaveId) {
            this.slaveId = slaveId;
            return this;
        }

        public DatabaseInstanceBuilder replicaOf(String replicaOf) {
            this.replicaOf = replicaOf;
            return this;
        }

        public DatabaseInstanceBuilder extendParam(ExtendParam extendParam) {
            this.extendParam = extendParam;
            return this;
        }

        public DatabaseInstance build() {
            return new DatabaseInstance(this.id, this.name, this.status, this.created, this.updated, this.hostname, this.type, this.region, this.availabilityZone, this.vpcId, this.nic, this.securityGroup, this.flavor, this.ip, this.volume, this.datastore, this.backupStrategy, this.ha, this.slaveId, this.replicaOf, this.extendParam);
        }

        public String toString() {
            return "DatabaseInstance.DatabaseInstanceBuilder(id=" + this.id + ", name=" + this.name + ", status=" + this.status + ", created=" + this.created + ", updated=" + this.updated + ", hostname=" + this.hostname + ", type=" + (Object)((Object)this.type) + ", region=" + this.region + ", availabilityZone=" + this.availabilityZone + ", vpcId=" + this.vpcId + ", nic=" + this.nic + ", securityGroup=" + this.securityGroup + ", flavor=" + this.flavor + ", ip=" + this.ip + ", volume=" + this.volume + ", datastore=" + this.datastore + ", backupStrategy=" + this.backupStrategy + ", ha=" + this.ha + ", slaveId=" + this.slaveId + ", replicaOf=" + this.replicaOf + ", extendParam=" + this.extendParam + ")";
        }
    }

    public static class DatabaseInstances
    extends ListResult<DatabaseInstance> {
        static final long serialVersionUID = 1L;
        @JsonProperty(value="instances")
        List<DatabaseInstance> instances;

        @Override
        protected List<DatabaseInstance> value() {
            return this.instances;
        }
    }
}

