/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.database.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.huawei.openstack4j.model.ModelEntity;
import com.huawei.openstack4j.openstack.database.constants.DatastoreType;
import java.beans.ConstructorProperties;

@JsonRootName(value="datastore")
public class Datastore
implements ModelEntity {
    private static final long serialVersionUID = 5294355671374520846L;
    @JsonProperty(value="type")
    DatastoreType type;
    @JsonProperty(value="version")
    String version;
    @JsonProperty(value="version_id")
    String versionId;

    public static DatastoreBuilder builder() {
        return new DatastoreBuilder();
    }

    public DatastoreBuilder toBuilder() {
        return new DatastoreBuilder().type(this.type).version(this.version).versionId(this.versionId);
    }

    public DatastoreType getType() {
        return this.type;
    }

    public String getVersion() {
        return this.version;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public String toString() {
        return "Datastore(type=" + (Object)((Object)this.getType()) + ", version=" + this.getVersion() + ", versionId=" + this.getVersionId() + ")";
    }

    public Datastore() {
    }

    @ConstructorProperties(value={"type", "version", "versionId"})
    public Datastore(DatastoreType type, String version, String versionId) {
        this.type = type;
        this.version = version;
        this.versionId = versionId;
    }

    public static class DatastoreBuilder {
        private DatastoreType type;
        private String version;
        private String versionId;

        DatastoreBuilder() {
        }

        public DatastoreBuilder type(DatastoreType type) {
            this.type = type;
            return this;
        }

        public DatastoreBuilder version(String version) {
            this.version = version;
            return this;
        }

        public DatastoreBuilder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public Datastore build() {
            return new Datastore(this.type, this.version, this.versionId);
        }

        public String toString() {
            return "Datastore.DatastoreBuilder(type=" + (Object)((Object)this.type) + ", version=" + this.version + ", versionId=" + this.versionId + ")";
        }
    }
}

