/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.database.internal;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.huawei.openstack4j.openstack.common.IdResourceEntity;
import com.huawei.openstack4j.openstack.database.domain.DatabaseInstance;
import com.huawei.openstack4j.openstack.database.domain.DatabaseInstanceCreate;
import com.huawei.openstack4j.openstack.database.domain.Volume;
import com.huawei.openstack4j.openstack.database.internal.BaseDatabaseServices;
import com.huawei.openstack4j.openstack.trove.domain.ExtendParam;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class DatabaseInstanceService
extends BaseDatabaseServices {
    public List<DatabaseInstance> list() {
        return this.get(DatabaseInstance.DatabaseInstances.class, this.uri("/instances", new Object[0])).execute().getList();
    }

    public DatabaseInstance get(String instanceId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)instanceId) ? 1 : 0) != 0, (Object)"parameter `instanceId` should not be empty");
        DatabaseInstance instance = this.get(DatabaseInstance.class, this.uri("/instances/%s", instanceId)).execute();
        return instance;
    }

    public DatabaseInstance create(DatabaseInstanceCreate creation) {
        Preconditions.checkNotNull((Object)creation, (Object)"parameter `creation` should not be null");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)creation.getName()) ? 1 : 0) != 0, (Object)"parameter `creation.name` should not be empty");
        Preconditions.checkNotNull((Object)creation.getDatastore(), (Object)"parameter `creation.datastore` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)creation.getDatastore().getVersion()) ? 1 : 0) != 0, (Object)"parameter `creation.datastore.version` should not be empty");
        Preconditions.checkNotNull((Object)((Object)creation.getDatastore().getType()), (Object)"parameter `creation.datastore.type` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)creation.getFlavorRef()) ? 1 : 0) != 0, (Object)"parameter `creation.flavorRef` should not be empty");
        return this.post(DatabaseInstance.class, this.uri("/instances", new Object[0])).entity(creation).execute();
    }

    public String delete(String instanceId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)instanceId) ? 1 : 0) != 0, (Object)"parameter `instanceId` should not be empty");
        HashMap entity = Maps.newHashMap();
        entity.put("keepLastManualBackup", "0");
        Job execute = this.delete(Job.class, this.uri("/instances/%s", instanceId)).entity(entity).execute();
        return execute.getId();
    }

    public List<String> restart(String instanceId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)instanceId) ? 1 : 0) != 0, (Object)"parameter `instanceId` should not be empty");
        HashMap entity = Maps.newHashMap();
        entity.put("restart", Maps.newHashMap());
        ArrayList jobIds = Lists.newArrayList();
        ExtendParam execute = this.post(ExtendParam.class, this.uri("/instances/%s/action", instanceId)).entity(entity).execute();
        for (IdResourceEntity job : execute.getJobs()) {
            jobIds.add(job.getId());
        }
        return jobIds;
    }

    public List<String> resize(String instanceId, String flavorRef) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)instanceId) ? 1 : 0) != 0, (Object)"parameter `instanceId` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)flavorRef) ? 1 : 0) != 0, (Object)"parameter `flavorRef` should not be empty");
        ResizeFlavorRequest entity = new ResizeFlavorRequest();
        entity.setFlavorRef(flavorRef);
        ResizeInstanceResponse execute = this.post(ResizeInstanceResponse.class, this.uri("/instances/%s/action", instanceId)).entity(entity).execute();
        return execute.getJobIds();
    }

    public List<String> resize(String instanceId, int volumeSize) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)instanceId) ? 1 : 0) != 0, (Object)"parameter `instanceId` should not be empty");
        Preconditions.checkArgument((volumeSize >= 110 && volumeSize <= 2000 ? 1 : 0) != 0, (Object)"parameter `volumeSize` shoule between 110 and 2000");
        ResizeVolumeRequest entity = new ResizeVolumeRequest();
        entity.setVolume(Volume.builder().size(volumeSize).build());
        ArrayList jobIds = Lists.newArrayList();
        ExtendParam execute = this.post(ExtendParam.class, this.uri("/instances/%s/action", instanceId)).entity(entity).execute();
        for (IdResourceEntity job : execute.getJobs()) {
            jobIds.add(job.getId());
        }
        return jobIds;
    }

    static class ResizeInstanceResponse {
        @JsonProperty(value="jobId")
        List<String> jobIds;

        ResizeInstanceResponse() {
        }

        public List<String> getJobIds() {
            return this.jobIds;
        }

        public void setJobIds(List<String> jobIds) {
            this.jobIds = jobIds;
        }
    }

    @JsonRootName(value="resize")
    class ResizeFlavorRequest {
        @JsonProperty(value="flavorRef")
        String flavorRef;

        ResizeFlavorRequest() {
        }

        public String getFlavorRef() {
            return this.flavorRef;
        }

        public void setFlavorRef(String flavorRef) {
            this.flavorRef = flavorRef;
        }
    }

    @JsonRootName(value="resize")
    class ResizeVolumeRequest {
        @JsonProperty(value="volume")
        Volume volume;

        ResizeVolumeRequest() {
        }

        public Volume getVolume() {
            return this.volume;
        }

        public void setVolume(Volume volume) {
            this.volume = volume;
        }
    }

    static class Job {
        @JsonProperty(value="jobId")
        String id;

        Job() {
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }
    }
}

