/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.database.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.huawei.openstack4j.openstack.database.domain.DatabaseParam;
import com.huawei.openstack4j.openstack.database.domain.InstanceParamOperationResult;
import com.huawei.openstack4j.openstack.database.internal.BaseDatabaseServices;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DatabaseParamService
extends BaseDatabaseServices {
    public List<DatabaseParam> list(String dataStoreVersionId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)dataStoreVersionId) ? 1 : 0) != 0, (Object)"parameter `dataStoreVersionId` should not be empty");
        return this.get(DatabaseParam.Parameters.class, this.uri("/datastores/versions/%s/parameters", dataStoreVersionId)).execute().getList();
    }

    public DatabaseParam get(String dataStoreVersionId, String paramName) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)dataStoreVersionId) ? 1 : 0) != 0, (Object)"parameter `dataStoreVersionId` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)paramName) ? 1 : 0) != 0, (Object)"parameter `paramName` should not be empty");
        return this.get(DatabaseParam.class, this.uri("/datastores/versions/%s/parameters/%s", dataStoreVersionId, paramName)).execute();
    }

    public InstanceParamOperationResult config(String instanceId, Map<String, Object> params) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)instanceId) ? 1 : 0) != 0, (Object)"parameter `instanceId` should not be empty");
        Preconditions.checkArgument((params != null && !params.isEmpty() ? 1 : 0) != 0, (Object)"parameter `params` should not be empty");
        HashMap entity = Maps.newHashMap();
        entity.put("values", params);
        return this.put(InstanceParamOperationResult.class, this.uri("/instances/%s/parameters", instanceId)).entity(entity).execute();
    }

    public InstanceParamOperationResult restore(String instanceId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)instanceId) ? 1 : 0) != 0, (Object)"parameter `instanceId` should not be empty");
        HashMap entity = Maps.newHashMap();
        return this.put(InstanceParamOperationResult.class, this.uri("/instances/%s/parameters/default", instanceId)).entity(entity).execute();
    }
}

