/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.database.options;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.huawei.openstack4j.openstack.common.DateTimeUtils;
import java.util.Date;
import java.util.Map;

public class ErrorLogListOptions {
    String instanceId;
    private Map<String, Object> queryParams = Maps.newHashMap();

    public ErrorLogListOptions instanceId(String instanceId) {
        this.instanceId = instanceId;
        return this;
    }

    public ErrorLogListOptions startDate(Date startDate) {
        Preconditions.checkArgument((startDate != null ? 1 : 0) != 0, (Object)"parameter `startDate` should not be null");
        String format = DateTimeUtils.format(startDate, "yyyy-MM-dd'+'HH:mm");
        return this.add("startDate", format);
    }

    public ErrorLogListOptions endDate(Date endDate) {
        Preconditions.checkArgument((endDate != null ? 1 : 0) != 0, (Object)"parameter `endDate` should not be null");
        String format = DateTimeUtils.format(endDate, "yyyy-MM-dd'+'HH:mm");
        return this.add("endDate", format);
    }

    public ErrorLogListOptions curPage(Integer page) {
        return this.add("curPage", page);
    }

    public ErrorLogListOptions perPage(Integer pageSize) {
        return this.add("perPage", pageSize);
    }

    private ErrorLogListOptions add(String param, Object value) {
        if (value != null) {
            this.queryParams.put(param, value);
        }
        return this;
    }

    public Map<String, Object> getOptions() {
        return this.queryParams;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public static ErrorLogListOptions create() {
        return new ErrorLogListOptions();
    }
}

