/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.dns.v2.internal;

import com.google.common.base.Preconditions;
import com.huawei.openstack4j.api.dns.v2.RecordsetService;
import com.huawei.openstack4j.model.dns.v2.RecordSetType;
import com.huawei.openstack4j.model.dns.v2.Recordset;
import com.huawei.openstack4j.openstack.dns.v2.domain.DesignateRecordset;
import com.huawei.openstack4j.openstack.dns.v2.internal.BaseDNSServices;
import com.huawei.openstack4j.openstack.dns.v2.options.RecordsetListOptions;
import com.huawei.openstack4j.openstack.internal.BaseOpenStackService;
import java.util.List;
import java.util.Map;

public class RecordsetServiceImpl
extends BaseDNSServices
implements RecordsetService {
    @Override
    public Recordset get(String zoneId, String recordsetId) {
        Preconditions.checkNotNull((Object)zoneId, (Object)"Zone Id should not be Null.");
        Preconditions.checkNotNull((Object)recordsetId, (Object)"The recordset Id should not be Null.");
        return this.get(DesignateRecordset.class, "/zones", "/", zoneId, "/recordsets", "/", recordsetId).execute();
    }

    @Override
    public Recordset delete(String zoneId, String recordsetId) {
        Preconditions.checkNotNull((Object)zoneId, (Object)"Zone Id should not be Null.");
        Preconditions.checkNotNull((Object)recordsetId, (Object)"The recordset Id should not be Null");
        return this.delete(DesignateRecordset.class, "/zones", "/", zoneId, "/recordsets", "/", recordsetId).execute();
    }

    @Override
    public Recordset create(String zoneId, Recordset recordset) {
        Preconditions.checkNotNull((Object)zoneId);
        Preconditions.checkNotNull((Object)recordset);
        return this.post(DesignateRecordset.class, "/zones", "/", zoneId, "/recordsets").entity(recordset).execute();
    }

    @Override
    public Recordset create(String zoneId, String name, String description, String type, Integer ttl, List<String> records) {
        Preconditions.checkNotNull((Object)zoneId, (Object)"ZoneId should not be Null.");
        Preconditions.checkNotNull((Object)name, (Object)"Name should not be Null.");
        Preconditions.checkNotNull((Object)type, (Object)"Type should not be Null.");
        Preconditions.checkNotNull((Object)ttl, (Object)"TTL should not be Null.");
        Preconditions.checkNotNull(records, (Object)"Records should not be Null.");
        return this.create(zoneId, (Recordset)DesignateRecordset.builder().name(name).type(RecordSetType.value(type)).description(description).ttl(ttl).records(records).build());
    }

    @Override
    public List<? extends Recordset> list(RecordsetListOptions options) {
        Map<String, Object> params = options == null ? null : options.getOptions();
        return this.get(DesignateRecordset.Recordsets.class, this.uri("/recordsets", new Object[0])).params(params).execute().getList();
    }

    @Override
    public List<? extends Recordset> list() {
        return this.get(DesignateRecordset.Recordsets.class, this.uri("/recordsets", new Object[0])).execute().getList();
    }

    @Override
    public List<? extends Recordset> list(String zoneId) {
        Preconditions.checkNotNull((Object)zoneId, (Object)"Zone Id should not be null.");
        return this.get(DesignateRecordset.Recordsets.class, "/zones", "/", zoneId, "/recordsets").execute().getList();
    }

    @Override
    public List<? extends Recordset> list(String zoneId, Integer limit, String marker) {
        Preconditions.checkNotNull((Object)zoneId, (Object)"Zone Id should not be null.");
        BaseOpenStackService.Invocation<DesignateRecordset.Recordsets> invocation = this.get(DesignateRecordset.Recordsets.class, "/zones", "/", zoneId, "/recordsets");
        invocation.param("marker", marker);
        invocation.param("limit", limit);
        return invocation.execute().getList();
    }
}

