/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.ecs.v1.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.huawei.openstack4j.model.ModelEntity;
import com.huawei.openstack4j.openstack.ecs.v1.domain.Ipv6BandWidth;
import java.beans.ConstructorProperties;

public class Network
implements ModelEntity {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="subnet_id")
    private String subnetId;
    @JsonProperty(value="ip_address")
    private String ipAddress;
    @JsonProperty(value="ipv6_enable")
    private Boolean ipv6Enable;
    @JsonProperty(value="ipv6_bandwidth")
    private Ipv6BandWidth ipv6Bandwidth;

    @ConstructorProperties(value={"subnetId", "ipAddress", "ipv6Enable", "ipv6Bandwidth"})
    public Network(String subnetId, String ipAddress, Boolean ipv6Enable, Ipv6BandWidth ipv6Bandwidth) {
        this.subnetId = subnetId;
        this.ipAddress = ipAddress;
        this.ipv6Enable = ipv6Enable;
        this.ipv6Bandwidth = ipv6Bandwidth;
    }

    public Network() {
    }

    public static NetworkBuilder builder() {
        return new NetworkBuilder();
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public Boolean getIpv6Enable() {
        return this.ipv6Enable;
    }

    public Ipv6BandWidth getIpv6Bandwidth() {
        return this.ipv6Bandwidth;
    }

    public String toString() {
        return "Network(subnetId=" + this.getSubnetId() + ", ipAddress=" + this.getIpAddress() + ", ipv6Enable=" + this.getIpv6Enable() + ", ipv6Bandwidth=" + this.getIpv6Bandwidth() + ")";
    }

    public NetworkBuilder toBuilder() {
        return new NetworkBuilder().subnetId(this.subnetId).ipAddress(this.ipAddress).ipv6Enable(this.ipv6Enable).ipv6Bandwidth(this.ipv6Bandwidth);
    }

    public static class NetworkBuilder {
        private String subnetId;
        private String ipAddress;
        private Boolean ipv6Enable;
        private Ipv6BandWidth ipv6Bandwidth;

        NetworkBuilder() {
        }

        public NetworkBuilder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public NetworkBuilder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public NetworkBuilder ipv6Enable(Boolean ipv6Enable) {
            this.ipv6Enable = ipv6Enable;
            return this;
        }

        public NetworkBuilder ipv6Bandwidth(Ipv6BandWidth ipv6Bandwidth) {
            this.ipv6Bandwidth = ipv6Bandwidth;
            return this;
        }

        public Network build() {
            return new Network(this.subnetId, this.ipAddress, this.ipv6Enable, this.ipv6Bandwidth);
        }

        public String toString() {
            return "Network.NetworkBuilder(subnetId=" + this.subnetId + ", ipAddress=" + this.ipAddress + ", ipv6Enable=" + this.ipv6Enable + ", ipv6Bandwidth=" + this.ipv6Bandwidth + ")";
        }
    }
}

