/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.ecs.v1.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.huawei.openstack4j.api.types.ServiceType;
import com.huawei.openstack4j.openstack.common.AsyncJobEntity;
import com.huawei.openstack4j.openstack.common.functions.ReplaceVersionOfURL;
import com.huawei.openstack4j.openstack.ecs.v1.domain.OSReinstall;
import com.huawei.openstack4j.openstack.ecs.v1.domain.ServerChangeOS;
import com.huawei.openstack4j.openstack.internal.BaseOpenStackService;

public class CloudServerV2Service
extends BaseOpenStackService {
    public CloudServerV2Service() {
        super(ServiceType.ECS, ReplaceVersionOfURL.instance("/v2"));
    }

    public String changeOS(ServerChangeOS change, String serverId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)change.getImageId()) ? 1 : 0) != 0, (Object)"parameter `imageid` should not be empty");
        return this.post(AsyncJobEntity.class, "/cloudservers/" + serverId + "/changeos").entity(change).execute().getId();
    }

    public AsyncJobEntity reinstallOS(OSReinstall osReinstall, String serverId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)serverId) ? 1 : 0) != 0, (Object)"parameter `serverId` should not be empty");
        Preconditions.checkArgument((osReinstall != null ? 1 : 0) != 0, (Object)"parameter `osReinstall` should not be empty");
        return this.post(AsyncJobEntity.class, this.uri("/cloudservers/" + serverId + "/reinstallos", new Object[0])).entity(osReinstall).execute();
    }
}

