/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.evs.v2.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.huawei.openstack4j.openstack.evs.v2.domain.CloudVolumeSnapshotsResponse;
import com.huawei.openstack4j.openstack.evs.v2.domain.Rollback;
import com.huawei.openstack4j.openstack.evs.v2.domain.RollbackResponse;
import com.huawei.openstack4j.openstack.evs.v2.internal.BaseElasticVolumeService;
import com.huawei.openstack4j.openstack.internal.BaseOpenStackService;
import java.util.HashMap;
import java.util.Map;

public class VolumeSnapshotService
extends BaseElasticVolumeService {
    public CloudVolumeSnapshotsResponse list() {
        return this.get(CloudVolumeSnapshotsResponse.class, this.uri("/cloudsnapshots/detail", new Object[0])).execute();
    }

    public CloudVolumeSnapshotsResponse list(Map<String, Object> filteringParams) {
        this.processListParams(filteringParams, "enterprise_project_ids");
        BaseOpenStackService.Invocation<CloudVolumeSnapshotsResponse> snapshotInvocation = this.buildInvocation(filteringParams);
        return snapshotInvocation.execute();
    }

    private BaseOpenStackService.Invocation<CloudVolumeSnapshotsResponse> buildInvocation(Map<String, Object> filteringParams) {
        BaseOpenStackService.Invocation<CloudVolumeSnapshotsResponse> snapshotInvocation = this.get(CloudVolumeSnapshotsResponse.class, "/cloudsnapshots/detail");
        if (filteringParams == null) {
            return snapshotInvocation;
        }
        for (Map.Entry<String, Object> entry : filteringParams.entrySet()) {
            snapshotInvocation = snapshotInvocation.param(entry.getKey(), entry.getValue());
        }
        return snapshotInvocation;
    }

    public RollbackResponse rollback(String snapshotId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)snapshotId) ? 1 : 0) != 0, (Object)"parameter snapshotId should not be empty");
        HashMap content = new HashMap();
        content.put("rollback", new HashMap());
        return this.post(RollbackResponse.class, this.uri("/cloudsnapshots/%s/rollback", snapshotId)).entity(content).execute();
    }

    public RollbackResponse rollback(String snapshotId, Rollback rollback) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)snapshotId) ? 1 : 0) != 0, (Object)"parameter snapshotId should not be empty");
        HashMap<String, Rollback> content = new HashMap<String, Rollback>();
        content.put("rollback", rollback);
        return this.post(RollbackResponse.class, this.uri("/cloudsnapshots/%s/rollback", snapshotId)).entity(content).execute();
    }
}

