/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.fgs.v2.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.openstack.fgs.v2.domain.FuncInvocations;
import com.huawei.openstack4j.openstack.fgs.v2.domain.FunctionMetadata;
import com.huawei.openstack4j.openstack.fgs.v2.internal.BaseFunctionGraphV2Service;
import java.util.HashMap;
import java.util.Map;

public class FunctionV2Service
extends BaseFunctionGraphV2Service {
    private final String urlFmt = "/fgs/functions/%s";

    public FunctionMetadata.Functions listFunction(Map<String, String> param) {
        int marker = Integer.parseInt(param.get("marker"));
        int maxItems = Integer.parseInt(param.get("maxItems"));
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)Integer.toString(marker)) ? 1 : 0) != 0, (Object)"parameter `marker` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)Integer.toString(maxItems)) ? 1 : 0) != 0, (Object)"parameter `maxItems` should not be empty");
        return this.get(FunctionMetadata.Functions.class, this.uri("/fgs/functions", new Object[0])).param("marker", marker).param("maxitems", maxItems).execute();
    }

    public FunctionMetadata.Functions listFunction() {
        return this.get(FunctionMetadata.Functions.class, this.uri("/fgs/functions", new Object[0])).execute();
    }

    public FunctionMetadata getFunctionMetadata(String functionUrn) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)functionUrn) ? 1 : 0) != 0, (Object)"parameter `functionUrn` should not be empty");
        String url = "/fgs/functions/%s/config";
        return this.get(FunctionMetadata.class, this.uri(url, functionUrn)).execute();
    }

    public FunctionMetadata getFunctionCode(String functionUrn) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)functionUrn) ? 1 : 0) != 0, (Object)"parameter `functionUrn` should not be empty");
        String url = "/fgs/functions/%s/code";
        return this.get(FunctionMetadata.class, this.uri(url, functionUrn)).execute();
    }

    public FunctionMetadata createFunction(FunctionMetadata functionMetadata) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)functionMetadata.getFuncName()) ? 1 : 0) != 0, (Object)"parameter `FuncName` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)functionMetadata.getPackageName()) ? 1 : 0) != 0, (Object)"parameter `Package` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)functionMetadata.getCodeType()) ? 1 : 0) != 0, (Object)"parameter `CodeType` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)functionMetadata.getHandler()) ? 1 : 0) != 0, (Object)"parameter `Handler` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)Integer.toString(functionMetadata.getMemorySize())) ? 1 : 0) != 0, (Object)"parameter `MemorySize` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)functionMetadata.getRuntime()) ? 1 : 0) != 0, (Object)"parameter `Runtime` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)Integer.toString(functionMetadata.getTimeout())) ? 1 : 0) != 0, (Object)"parameter `Timeout` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)functionMetadata.getFuncCode().getFile()) ? 1 : 0) != 0, (Object)"parameter `FuncCode.File` should not be empty");
        return this.post(FunctionMetadata.class, "/fgs/functions").entity(functionMetadata).execute();
    }

    public ActionResponse deleteFunction(String functionUrn) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)functionUrn) ? 1 : 0) != 0, (Object)"parameter `functionUrn` should not be empty");
        return this.deleteWithResponse(this.uri("/fgs/functions/%s", functionUrn)).execute();
    }

    public FunctionMetadata updateFunctionCode(String functionUrn, FunctionMetadata functionMetadata) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)functionUrn) ? 1 : 0) != 0, (Object)"parameter `functionUrn` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)functionMetadata.getCodeType()) ? 1 : 0) != 0, (Object)"parameter `CodeType` should not be empty");
        String url = "/fgs/functions/%s/code";
        return this.put(FunctionMetadata.class, this.uri(url, functionUrn)).entity(functionMetadata).execute();
    }

    public FunctionMetadata updateFunctionConfig(String functionUrn, FunctionMetadata functionMetadata) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)functionUrn) ? 1 : 0) != 0, (Object)"parameter `functionUrn` should not be empty");
        Preconditions.checkArgument((functionMetadata.getStrategyConfig() != null ? 1 : 0) != 0, (Object)"parameter `StrategyConfig` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)Integer.toString(functionMetadata.getStrategyConfig().getConcurrency())) ? 1 : 0) != 0, (Object)"parameter `StrategyConfig.Concurrency` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)functionMetadata.getHandler()) ? 1 : 0) != 0, (Object)"parameter `Handler` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)Integer.toString(functionMetadata.getMemorySize())) ? 1 : 0) != 0, (Object)"parameter `MemorySize` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)functionMetadata.getRuntime()) ? 1 : 0) != 0, (Object)"parameter `Runtime` should not be empty");
        String url = "/fgs/functions/%s/config";
        return this.put(FunctionMetadata.class, this.uri(url, functionUrn)).entity(functionMetadata).execute();
    }

    public FunctionMetadata createFunctionVersion(String functionUrn, FunctionMetadata functionMetadata) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)functionUrn) ? 1 : 0) != 0, (Object)"parameter `functionUrn` should not be empty");
        String url = "/fgs/functions/%s/versions";
        return this.post(FunctionMetadata.class, this.uri(url, functionUrn)).entity(functionMetadata).execute();
    }

    public FunctionMetadata.FunctionVersions listFunctionVersion(String functionUrn, Map<String, String> param) {
        int marker = Integer.parseInt(param.get("marker"));
        int maxItems = Integer.parseInt(param.get("maxItems"));
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)functionUrn) ? 1 : 0) != 0, (Object)"parameter `functionUrn` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)Integer.toString(marker)) ? 1 : 0) != 0, (Object)"parameter `marker` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)Integer.toString(maxItems)) ? 1 : 0) != 0, (Object)"parameter `maxItems` should not be empty");
        String url = "/fgs/functions/%s/versions";
        return this.get(FunctionMetadata.FunctionVersions.class, this.uri(url, functionUrn)).param("marker", marker).param("maxitems", maxItems).execute();
    }

    public FunctionMetadata.FunctionVersions listFunctionVersion(String functionUrn) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)functionUrn) ? 1 : 0) != 0, (Object)"parameter `functionUrn` should not be empty");
        String url = "/fgs/functions/%s/versions";
        return this.get(FunctionMetadata.FunctionVersions.class, this.uri(url, functionUrn)).execute();
    }

    public FuncInvocations invokeFunction(String functionUrn, Map<?, ?> data) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)functionUrn) ? 1 : 0) != 0, (Object)"parameter `functionUrn` should not be empty");
        String url = "/fgs/functions/%s/invocations";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("x-cff-request-version", "v1");
        map.put("x-cff-log-type", "tail");
        return this.post(FuncInvocations.class, this.uri(url, functionUrn)).headers(map).entity(data).execute();
    }

    public FuncInvocations asyncInvokeFunction(String functionUrn, Map<?, ?> data) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)functionUrn) ? 1 : 0) != 0, (Object)"parameter `functionUrn` should not be empty");
        String url = "/fgs/functions/%s/invocations-async";
        return this.post(FuncInvocations.class, this.uri(url, functionUrn)).entity(data).execute();
    }
}

