/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.gbp.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Maps;
import com.huawei.openstack4j.model.gbp.ExternalPolicyCreate;
import com.huawei.openstack4j.model.gbp.builder.ExternalPolicyBuilder;
import java.util.List;
import java.util.Map;

@JsonRootName(value="external_policy")
public class GbpExternalPolicyCreate
implements ExternalPolicyCreate {
    private static final long serialVersionUID = 1L;
    private String name;
    private String description;
    @JsonProperty(value="tenant_id")
    private String tenantId;
    private String id;
    @JsonProperty(value="consumed_policy_rule_sets")
    private Map<String, String> consumedPolicyRuleSets;
    @JsonProperty(value="provided_policy_rule_sets")
    private Map<String, String> providedPolicyRuleSets;
    @JsonProperty(value="external_segments")
    private List<String> externalSegments;
    private Boolean shared;

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public Map<String, String> getConsumedPolicyRuleSets() {
        return this.consumedPolicyRuleSets;
    }

    @Override
    public Map<String, String> getProvidedPolicyRuleSets() {
        return this.providedPolicyRuleSets;
    }

    @Override
    public List<String> getExternalSegments() {
        return this.externalSegments;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean isShared() {
        return this.shared == null ? false : this.shared;
    }

    @Override
    public ExternalPolicyBuilder toBuilder() {
        return new ExternalPolicyConcreteBuilder(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("name", (Object)this.name).add("tenantId", (Object)this.tenantId).add("externalSegments", this.externalSegments).add("id", (Object)this.id).add("description", (Object)this.description).add("shared", (Object)this.shared).add("consumedPolicyRuleSets", this.consumedPolicyRuleSets).add("providedPolicyRuleSets", this.providedPolicyRuleSets).toString();
    }

    public static ExternalPolicyBuilder builder() {
        return new ExternalPolicyConcreteBuilder();
    }

    public static class ExternalPolicyConcreteBuilder
    implements ExternalPolicyBuilder {
        private GbpExternalPolicyCreate extPolicy;

        public ExternalPolicyConcreteBuilder() {
            this(new GbpExternalPolicyCreate());
        }

        public ExternalPolicyConcreteBuilder(GbpExternalPolicyCreate gbpExternalPolicy) {
            this.extPolicy = gbpExternalPolicy;
        }

        @Override
        public ExternalPolicyCreate build() {
            return this.extPolicy;
        }

        @Override
        public ExternalPolicyBuilder from(ExternalPolicyCreate in) {
            this.extPolicy = (GbpExternalPolicyCreate)in;
            return this;
        }

        @Override
        public ExternalPolicyBuilder name(String name) {
            this.extPolicy.name = name;
            return this;
        }

        @Override
        public ExternalPolicyBuilder description(String description) {
            this.extPolicy.description = description;
            return this;
        }

        @Override
        public ExternalPolicyBuilder isShared(boolean shared) {
            this.extPolicy.shared = shared;
            return this;
        }

        @Override
        public ExternalPolicyBuilder consumedPolicyRuleSets(List<String> policyRuleSet) {
            this.extPolicy.consumedPolicyRuleSets = Maps.newHashMap();
            for (String id : policyRuleSet) {
                this.extPolicy.consumedPolicyRuleSets.put(id, "");
            }
            return this;
        }

        @Override
        public ExternalPolicyBuilder providedPolicyRuleSets(List<String> policyRuleSet) {
            this.extPolicy.providedPolicyRuleSets = Maps.newHashMap();
            for (String id : policyRuleSet) {
                this.extPolicy.providedPolicyRuleSets.put(id, "");
            }
            return this;
        }

        @Override
        public ExternalPolicyBuilder externalSegments(List<String> externalSegmentIds) {
            this.extPolicy.externalSegments = externalSegmentIds;
            return this;
        }
    }
}

