/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.gbp.internal;

import com.google.common.base.Preconditions;
import com.huawei.openstack4j.api.gbp.ExternalSegmentService;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.model.gbp.ExternalSegment;
import com.huawei.openstack4j.openstack.gbp.domain.GbpExternalSegment;
import com.huawei.openstack4j.openstack.internal.BaseOpenStackService;
import com.huawei.openstack4j.openstack.networking.internal.BaseNetworkingServices;
import java.util.List;
import java.util.Map;

public class ExternalSegmentServiceImpl
extends BaseNetworkingServices
implements ExternalSegmentService {
    @Override
    public List<? extends ExternalSegment> list() {
        return this.get(GbpExternalSegment.ExternalSegments.class, this.uri("/grouppolicy/external_segments", new Object[0])).execute().getList();
    }

    @Override
    public List<? extends ExternalSegment> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<GbpExternalSegment.ExternalSegments> externalSegmentInvocation = this.buildInvocation(filteringParams);
        return externalSegmentInvocation.execute().getList();
    }

    private BaseOpenStackService.Invocation<GbpExternalSegment.ExternalSegments> buildInvocation(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<GbpExternalSegment.ExternalSegments> externalSegmentInvocation = this.get(GbpExternalSegment.ExternalSegments.class, "/grouppolicy/external_segments");
        if (filteringParams == null) {
            return externalSegmentInvocation;
        }
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                externalSegmentInvocation = externalSegmentInvocation.param(entry.getKey(), entry.getValue());
            }
        }
        return externalSegmentInvocation;
    }

    @Override
    public ExternalSegment get(String id) {
        Preconditions.checkNotNull((Object)id);
        return this.get(GbpExternalSegment.class, this.uri("/grouppolicy/external_segments/%s", id)).execute();
    }

    @Override
    public ActionResponse delete(String id) {
        Preconditions.checkNotNull((Object)id);
        return this.deleteWithResponse(this.uri("/grouppolicy/external_segments/%s", id)).execute();
    }

    @Override
    public ExternalSegment create(ExternalSegment externalSegment) {
        return this.post(GbpExternalSegment.class, this.uri("/grouppolicy/external_segments", new Object[0])).entity(externalSegment).execute();
    }

    @Override
    public ExternalSegment update(String externalSegmentId, ExternalSegment externalSegment) {
        Preconditions.checkNotNull((Object)externalSegmentId);
        Preconditions.checkNotNull((Object)externalSegment);
        return this.put(GbpExternalSegment.class, this.uri("/grouppolicy/external_segments/%s", externalSegmentId)).entity(externalSegment).execute();
    }
}

