/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.heat.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import com.huawei.openstack4j.model.heat.SoftwareConfig;
import com.huawei.openstack4j.model.heat.builder.SoftwareConfigBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@JsonRootName(value="software_config")
@JsonIgnoreProperties(ignoreUnknown=true)
public class HeatSoftwareConfig
implements SoftwareConfig {
    private static final long serialVersionUID = 1L;
    @JsonProperty
    String id;
    @JsonProperty
    String name;
    @JsonProperty
    String group;
    @JsonProperty
    String config;
    @JsonProperty
    List<SCInput> inputs;
    @JsonProperty
    List<SCOutput> outputs;
    @JsonProperty
    Map<String, Object> options;

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public String getConfig() {
        return this.config;
    }

    @Override
    public List<? extends SoftwareConfig.Input> getInputs() {
        return this.inputs != null ? this.inputs : Collections.emptyList();
    }

    @Override
    public List<? extends SoftwareConfig.Output> getOutputs() {
        return this.outputs != null ? this.outputs : Collections.emptyList();
    }

    @Override
    public Map<String, Object> getOptions() {
        return this.options;
    }

    @Override
    public SoftwareConfigBuilder toBuilder() {
        return new Builder(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper(SoftwareConfig.class).omitNullValues().add("id", (Object)this.id).add("name", (Object)this.name).add("group", (Object)this.group).addValue((Object)"\n").add("inputs", this.inputs).addValue((Object)"\n").add("outputs", this.outputs).addValue((Object)"\n").add("config", (Object)this.config).add("options", this.options).toString();
    }

    public static class Builder
    implements SoftwareConfigBuilder {
        private HeatSoftwareConfig sc;

        public Builder() {
            this.sc = new HeatSoftwareConfig();
        }

        Builder(HeatSoftwareConfig sc) {
            this.sc = sc;
        }

        @Override
        public SoftwareConfig build() {
            return this.sc;
        }

        @Override
        public SoftwareConfigBuilder from(SoftwareConfig in) {
            return new Builder((HeatSoftwareConfig)in);
        }

        @Override
        public SoftwareConfigBuilder name(String name) {
            this.sc.name = name;
            return this;
        }

        @Override
        public SoftwareConfigBuilder group(String group) {
            this.sc.group = group;
            return this;
        }

        @Override
        public SoftwareConfigBuilder input(String name) {
            this.input(name, null, null, null);
            return this;
        }

        @Override
        public SoftwareConfigBuilder input(String name, String type) {
            this.input(name, type, null, null);
            return this;
        }

        @Override
        public SoftwareConfigBuilder input(String name, String type, String description, String defaultValue) {
            if (this.sc.inputs == null) {
                this.sc.inputs = Lists.newArrayList();
            }
            this.sc.inputs.add(new SCInput(name, type, description, defaultValue));
            return this;
        }

        @Override
        public SoftwareConfigBuilder output(String name) {
            this.output(name, null, null, false);
            return this;
        }

        @Override
        public SoftwareConfigBuilder output(String name, String type) {
            this.output(name, type, null, false);
            return this;
        }

        @Override
        public SoftwareConfigBuilder output(String name, String type, String description, boolean isErrorOutput) {
            if (this.sc.outputs == null) {
                this.sc.outputs = Lists.newArrayList();
            }
            this.sc.outputs.add(new SCOutput(name, type, description, isErrorOutput));
            return this;
        }

        @Override
        public SoftwareConfigBuilder options(Map<String, Object> options) {
            this.sc.options = options;
            return this;
        }

        @Override
        public SoftwareConfigBuilder config(String config) {
            this.sc.config = config;
            return this;
        }
    }

    public static class SCOutput
    implements SoftwareConfig.Output {
        @JsonProperty(value="name")
        String name;
        @JsonProperty(value="description")
        String description;
        @JsonProperty(value="error_output")
        boolean errorOutput;
        @JsonProperty(value="type")
        String type;

        public SCOutput() {
        }

        public SCOutput(String name, String type, String description, boolean errorOutput) {
            this.name = name;
            this.type = type;
            this.description = description;
            this.errorOutput = errorOutput;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        public boolean isErrorOutput() {
            return this.errorOutput;
        }

        public String toString() {
            return MoreObjects.toStringHelper(SoftwareConfig.Output.class).omitNullValues().add("name", (Object)this.name).add("type", (Object)this.type).add("description", (Object)this.description).add("errorOutput", this.errorOutput).toString();
        }
    }

    public static class SCInput
    implements SoftwareConfig.Input {
        @JsonProperty(value="name")
        String name;
        @JsonProperty(value="description")
        String description;
        @JsonProperty(value="default")
        String defaultValue;
        @JsonProperty(value="type")
        String type;

        public SCInput() {
        }

        public SCInput(String name, String type, String description, String defaultValue) {
            this.name = name;
            this.type = type;
            this.description = description;
            this.defaultValue = defaultValue;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public String getDefaultValue() {
            return this.defaultValue;
        }

        @Override
        public String getType() {
            return this.type;
        }

        public String toString() {
            return MoreObjects.toStringHelper(SoftwareConfig.Input.class).omitNullValues().add("name", (Object)this.name).add("type", (Object)this.type).add("description", (Object)this.description).add("default", (Object)this.defaultValue).toString();
        }
    }
}

