/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.heat.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.huawei.openstack4j.model.heat.StackCreate;
import com.huawei.openstack4j.model.heat.builder.StackCreateBuilder;
import com.huawei.openstack4j.openstack.heat.utils.Environment;
import com.huawei.openstack4j.openstack.heat.utils.Template;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeatStackCreate
implements StackCreate {
    private static final long serialVersionUID = -8775995682456485275L;
    private static final Logger LOG = LoggerFactory.getLogger(HeatStackCreate.class);
    @JsonProperty(value="disableRollback")
    private boolean disableRollback;
    @JsonProperty(value="stack_name")
    private String name;
    @JsonProperty(value="template")
    private String template;
    @JsonProperty(value="template_url")
    private String templateURL;
    @JsonProperty(value="parameters")
    private Map<String, String> parameters;
    @JsonProperty(value="timeout_mins")
    private Long timeoutMins;
    @JsonProperty(value="environment")
    private String environment;
    @JsonProperty(value="files")
    private Map<String, String> files = new HashMap<String, String>();
    @JsonProperty(value="tags")
    private String tags;

    public static HeatStackCreateConcreteBuilder build() {
        return new HeatStackCreateConcreteBuilder();
    }

    @Override
    public StackCreateBuilder toBuilder() {
        return new HeatStackCreateConcreteBuilder(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    @Override
    public boolean getDisableRollback() {
        return this.disableRollback;
    }

    @Override
    public String getTemplate() {
        return this.template;
    }

    public String getTempateURL() {
        return this.templateURL;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public Map<String, String> getFiles() {
        return this.files;
    }

    public String getTags() {
        return this.tags;
    }

    public static class HeatStackCreateConcreteBuilder
    implements StackCreateBuilder {
        private HeatStackCreate model;

        public HeatStackCreateConcreteBuilder() {
            this(new HeatStackCreate());
        }

        public HeatStackCreateConcreteBuilder(HeatStackCreate model) {
            this.model = model;
        }

        @Override
        public StackCreate build() {
            return this.model;
        }

        @Override
        public StackCreateBuilder from(StackCreate in) {
            this.model = (HeatStackCreate)in;
            return this;
        }

        @Override
        public StackCreateBuilder name(String name) {
            this.model.name = name;
            return this;
        }

        @Override
        public StackCreateBuilder parameters(Map<String, String> parameters) {
            this.model.parameters = parameters;
            return this;
        }

        @Override
        public StackCreateBuilder timeoutMins(Long timeoutMins) {
            this.model.timeoutMins = timeoutMins;
            return this;
        }

        @Override
        public StackCreateBuilder disableRollback(boolean disableRollback) {
            this.model.disableRollback = disableRollback;
            return this;
        }

        @Override
        public StackCreateBuilder template(String template) {
            this.model.template = template;
            return this;
        }

        @Override
        public StackCreateBuilder templateFromFile(String tplFile) {
            try {
                Template tpl = new Template(tplFile);
                this.model.template = tpl.getTplContent();
                this.model.files.putAll(tpl.getFiles());
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
            return this;
        }

        @Override
        public StackCreateBuilder templateURL(String templateURL) {
            this.model.templateURL = templateURL;
            return this;
        }

        @Override
        public StackCreateBuilder environment(String environment) {
            this.model.environment = environment;
            return this;
        }

        @Override
        public StackCreateBuilder environmentFromFile(String envFile) {
            try {
                Environment env = new Environment(envFile);
                this.model.environment = env.getEnvContent();
                this.model.files.putAll(env.getFiles());
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
            return this;
        }

        @Override
        public StackCreateBuilder files(Map<String, String> files) {
            this.model.files = files;
            return this;
        }

        @Override
        public StackCreateBuilder tags(String tags) {
            this.model.tags = tags;
            return this;
        }
    }
}

