/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.heat.internal;

import com.google.common.base.Preconditions;
import com.huawei.openstack4j.api.Builders;
import com.huawei.openstack4j.api.heat.StackService;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.model.heat.Stack;
import com.huawei.openstack4j.model.heat.StackCreate;
import com.huawei.openstack4j.model.heat.StackUpdate;
import com.huawei.openstack4j.openstack.compute.functions.ToActionResponseFunction;
import com.huawei.openstack4j.openstack.heat.domain.HeatStack;
import com.huawei.openstack4j.openstack.heat.internal.BaseHeatServices;
import com.huawei.openstack4j.openstack.internal.BaseOpenStackService;
import java.util.List;
import java.util.Map;

public class StackServiceImpl
extends BaseHeatServices
implements StackService {
    @Override
    public Stack create(StackCreate newStack) {
        Preconditions.checkNotNull((Object)newStack);
        return this.post(HeatStack.class, this.uri("/stacks", new Object[0])).entity(newStack).execute();
    }

    @Override
    public Stack create(String name, String template, Map<String, String> parameters, boolean disableRollback, Long timeoutMins) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)template);
        Preconditions.checkNotNull(parameters);
        Preconditions.checkNotNull((Object)timeoutMins);
        return this.create((StackCreate)Builders.stack().name(name).template(template).parameters(parameters).timeoutMins(timeoutMins).build());
    }

    @Override
    public List<? extends Stack> list() {
        return this.get(HeatStack.Stacks.class, this.uri("/stacks", new Object[0])).execute().getList();
    }

    @Override
    public List<? extends Stack> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<HeatStack.Stacks> req = this.get(HeatStack.Stacks.class, this.uri("/stacks", new Object[0]));
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                req = req.param(entry.getKey(), entry.getValue());
            }
        }
        return req.execute().getList();
    }

    @Override
    public ActionResponse delete(String stackName, String stackId) {
        Preconditions.checkNotNull((Object)stackId);
        return this.deleteWithResponse(this.uri("/stacks/%s/%s", stackName, stackId)).execute();
    }

    @Override
    public Stack getDetails(String stackName, String stackId) {
        Preconditions.checkNotNull((Object)stackName);
        Preconditions.checkNotNull((Object)stackId);
        return this.get(HeatStack.class, this.uri("/stacks/%s/%s", stackName, stackId)).execute();
    }

    @Override
    public ActionResponse update(String stackName, String stackId, StackUpdate stackUpdate) {
        Preconditions.checkNotNull((Object)stackName);
        Preconditions.checkNotNull((Object)stackId);
        Preconditions.checkNotNull((Object)stackUpdate);
        return ToActionResponseFunction.INSTANCE.apply(this.put(Void.class, this.uri("/stacks/%s/%s", stackName, stackId)).entity(stackUpdate).executeWithResponse());
    }

    @Override
    public Stack getStackByName(String stackName) {
        Preconditions.checkNotNull((Object)stackName);
        return this.get(HeatStack.class, this.uri("/stacks/%s", stackName)).execute();
    }
}

